/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.auth.cstore.xml;

import org.bluestemsoftware.specification.eoa.ext.feature.auth.cstore.ClearTextPassword;
import org.bluestemsoftware.specification.eoa.ext.feature.auth.cstore.CredentialStoreFeatureFactory;
import org.bluestemsoftware.specification.eoa.ext.feature.auth.jaas.LoginCredentials;

public class ClearTextPasswordImpl implements ClearTextPassword {

    private CredentialStoreFeatureFactory factory;
    private String credential;

    public ClearTextPasswordImpl(CredentialStoreFeatureFactory factory, String credential) {
        this.factory = factory;
        this.credential = credential;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.auth.cstore.ClearTextPassword#getText()
     */
    public String getText() {
        return credential;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.auth.cstore.Password#check(java.lang.Object)
     */
    public boolean check(Object credential) {
        if (credential instanceof LoginCredentials) {
            return ((LoginCredentials)credential).check(this);
        } else {
            return credential != null && this.equals(credential);
        }
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ClearTextPassword) {
            Thread thread = Thread.currentThread();
            ClassLoader cl = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(factory.getFactoryContext().getClassLoader());
                return credential.equals(((ClearTextPassword)obj).getText());
            } finally {
                thread.setContextClassLoader(cl);
            }
        } else {
            if (obj instanceof String) {
                return obj.equals(getText());
            }
            return false;
        }
    }
    
    @Override
    public String toString() {
        return getText();
    }

}
