/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.auth.cstore.xml;

import java.util.Map;

import org.bluestemsoftware.specification.eoa.ext.feature.auth.HostInfo;
import org.bluestemsoftware.specification.eoa.ext.feature.auth.cstore.Credential;
import org.bluestemsoftware.specification.eoa.ext.feature.auth.cstore.CredentialStore;

public class CredentialStoreImpl implements CredentialStore {

    private String id;
    private Map<HostInfo, Map<String, Map<String, Credential>>> hosts;
    
    public CredentialStoreImpl(String id, Map<HostInfo, Map<String, Map<String, Credential>>> hosts) {
        this.id = id;
        this.hosts = hosts;
    }
    
    public String getID() {
        return id;
    }

    public Credential getCredential(HostInfo hostInfo, String realm, String userName) {
        Map<String, Map<String, Credential>> realms = hosts.get(hostInfo);
        if (realms == null) {
            return null;
        }
        Map<String, Credential> users = realms.get(realm);
        if (users == null) {
            return null;
        }
        return users.get(userName);
    }

}
