/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.auth.cstore.xml;

import org.bluestemsoftware.specification.eoa.ext.feature.auth.cstore.CredentialStoreFeatureFactory;
import org.bluestemsoftware.specification.eoa.ext.feature.auth.cstore.MessageDigestPassword;
import org.bluestemsoftware.specification.eoa.ext.feature.auth.jaas.LoginCredentials;

public class MessageDigestPasswordImpl implements MessageDigestPassword {

    protected CredentialStoreFeatureFactory factory;
    protected org.mortbay.jetty.security.Credential.MD5 underlying;
    
    public MessageDigestPasswordImpl(CredentialStoreFeatureFactory factory,
            org.mortbay.jetty.security.Credential.MD5 underlying) {
        this.factory = factory;
        this.underlying = underlying;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.auth.cstore.MessageDigestPassword#getDigest()
     */
    public byte[] getDigest() {
        return underlying.getDigest();
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.auth.cstore.MessageDigestPassword#getAlgorithm()
     */
    public String getAlgorithm() {
        return "MD5";
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.auth.cstore.Password#check(java.lang.Object)
     */
    public boolean check(Object credential) {
        if (credential == null) {
            return false;
        }
        if (credential instanceof MessageDigestPasswordImpl) {
            Thread thread = Thread.currentThread();
            ClassLoader cl = thread.getContextClassLoader();
            try {
                org.mortbay.jetty.security.Credential.MD5 p = ((MessageDigestPasswordImpl)credential).underlying;
                thread.setContextClassLoader(factory.getFactoryContext().getClassLoader());
                return underlying.check(p);
            } finally {
                thread.setContextClassLoader(cl);
            }
        } else if (credential instanceof LoginCredentials) {
            return ((LoginCredentials)credential).check(this);
        } else {
            return false;
        }
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MessageDigestPasswordImpl) {
            Thread thread = Thread.currentThread();
            ClassLoader cl = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(factory.getFactoryContext().getClassLoader());
                return underlying.check(((MessageDigestPasswordImpl)obj).underlying);
            } finally {
                thread.setContextClassLoader(cl);
            }
        } else {
            return false;
        }
    }
    


}
