/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.auth.cstore.xml.util;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class DOMSerializer {
    
private static DOMImplementationRegistry registry;
    
    public static String FORMAT_PRETTY_PRINT = "format-pretty-print";
    public static String XML_DECLARATION = "xml-declaration";
    
    public static void serializeNode(Node node, Writer writer, String encoding, boolean indent) throws Exception {
        Map<String, Object> parameters = new HashMap<String, Object>();
        if (indent) {
            parameters.put(FORMAT_PRETTY_PRINT, true);
        }
        parameters.put(XML_DECLARATION, false);
        serializeNode(node, writer, encoding, parameters);
    }
    
    public static void serializeNode(Node node, Writer writer, String encoding, Map<String, Object> parameters) throws Exception {

        if (registry == null) {
            try {
                registry = DOMImplementationRegistry.newInstance();
            } catch (Exception ex) {
                throw new IOException(ex.toString());
            }
        }

        DOMImplementationLS impl = (DOMImplementationLS)registry.getDOMImplementation("LS");
        LSSerializer lsSerializer = impl.createLSSerializer();
        LSOutput destination = impl.createLSOutput();
        destination.setCharacterStream(writer);
        destination.setEncoding(encoding);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            lsSerializer.getDomConfig().setParameter(entry.getKey(), entry.getValue());
        }
        lsSerializer.write(node, destination);

    }

    
}
