/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.engine.default10;

import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory;
import org.bluestemsoftware.specification.eoa.ext.engine.default10.DefaultEngineFactory;


public class DefaultEngineFactoryImpl implements DefaultEngineFactory.Provider {

    private static final long serialVersionUID = 1L;
    protected DefaultEngineFactory consumer;

    public static final String NAME = "default-10-engine";

    public DefaultEngineFactoryImpl() {        
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.ExtensionFactory)
     */
    public void spi_setConsumer(ExtensionFactory consumer) {
        this.consumer = (DefaultEngineFactory)consumer;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }
    
}
