/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.message.default10;

import java.io.InputStream;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.bluestemsoftware.open.eoa.aspect.axiom.util.STAXUtils;
import org.bluestemsoftware.open.eoa.ext.message.axiom.AbstractMessage;
import org.bluestemsoftware.open.eoa.ext.message.default10.util.OMDOMFactoryImpl;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory;
import org.bluestemsoftware.specification.eoa.ext.message.default10.DefaultMessage;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class DefaultMessageImpl extends AbstractMessage implements DefaultMessage, DefaultMessage.Provider {

    public DefaultMessageImpl(DocumentImpl ownerDocument, OMFactory factory) {
        super(ownerDocument, factory);
    }

    public DefaultMessageImpl(OMFactory factory) {
        super(factory);
    }

    public DefaultMessageImpl(OMXMLParserWrapper parserWrapper, OMFactory factory) {
        super(parserWrapper, factory);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.RootExtension#getExtensionType()
     */
    public final String getExtensionType() {
        return DefaultMessage.TYPE;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.Extension#getExtensionFactory()
     */
    @Override
    public final ExtensionFactory getExtensionFactory() {
        return SystemContext.getContext().getSystem().getMessageFactory(DefaultMessage.TYPE);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.component.message.rt.Message#cloneDefinition()
     */
    public DefaultMessage cloneDefinition() {
        if (this.messageDefinition == null) {
            throw new IllegalStateException("message has no source");
        }
        ExtensionFactory ef = getExtensionFactory();
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(ef.getFactoryContext().getClassLoader());
            InputStream in = this.messageDefinition.newInputStream();
            OMFactory omf = new OMDOMFactoryImpl();
            XMLStreamReader reader = STAXUtils.createXMLStreamReader(in, "UTF-8");
            StAXOMBuilder builder = new StAXOMBuilder(omf, reader);
            DefaultMessageImpl clone = (DefaultMessageImpl)builder.getDocument();
            clone.setComponentName(this.componentName);
            clone.setMessageDefinition(this.messageDefinition);
            clone.isDeployed = Boolean.TRUE;
            return clone;
        } catch (XMLStreamException xe) {
            throw new RuntimeException(xe);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    /*
     * TODO: remove (AS OF VERSION 1.2.5 SUPER THROWS UNSUPPORTED OPERATION EXCEPTION)
     */
    @Override
    public DOMImplementation getImplementation() {
        return new DOMImplementation() {

            public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
                return new OMDOMFactoryImpl().getDocument();
            }

            public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
                throw new UnsupportedOperationException();
            }

            public Object getFeature(String feature, String version) {
                return null;
            }

            public boolean hasFeature(String feature, String version) {
                return false;
            }

        };
    }

}
