/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.message.default10.util;

import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.bluestemsoftware.open.eoa.ext.message.default10.DefaultMessageImpl;

public class OMDOMFactoryImpl extends OMDOMFactory {

    @Override
    public OMDocument createOMDocument() {
        if (document == null) {
            document = new DefaultMessageImpl(this);
        }
        return document;
    }

    @Override
    public OMDocument createOMDocument(OMXMLParserWrapper builder) {
        if (document == null) {
            document = new DefaultMessageImpl(builder, this);
        }
        return document;
    }
    
}
