/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.message.default10;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

import javax.xml.XMLConstants;
import javax.xml.transform.dom.DOMSource;

import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.bluestemsoftware.open.eoa.aspect.axiom.util.STAXUtils;
import org.bluestemsoftware.open.eoa.ext.message.axiom.util.MessageDefinition;
import org.bluestemsoftware.open.eoa.ext.message.default10.util.OMDOMFactoryImpl;
import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.component.message.InterfaceMessage;
import org.bluestemsoftware.specification.eoa.component.message.MessagePart;
import org.bluestemsoftware.specification.eoa.ext.message.default10.DefaultMessage;
import org.bluestemsoftware.specification.eoa.ext.message.default10.DefaultMessageFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.EntityResolver;

public final class DefaultMessageFactoryImpl implements DefaultMessageFactory.Provider {

    public static final String NAME = "default-10-message";

    public DefaultMessageFactoryImpl() {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.message.default10.DefaultMessageFactory$Provider#spi_createDefaultMessage(org.bluestemsoftware.specification.eoa.component.message.InterfaceMessage)
     */
    public DefaultMessage spi_createDefaultMessage(InterfaceMessage interfaceMessage) {

        OMFactory omFactory = new OMDOMFactoryImpl();
        DefaultMessageImpl message = (DefaultMessageImpl)omFactory.createOMDocument();
        Element root = message.createElementNS(DefaultMessage.TYPE, "eoa:message");
        ComponentName name = interfaceMessage.getName();
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", name.getNamespaceURI());
        root.setAttribute("name", "tns:" + name.getLocalPart());

        message.appendChild(root);
        message.setComponentName(name);

        for (MessagePart part : interfaceMessage.getParts()) {
            Element partElement = message.createElementNS(XMLConstants.NULL_NS_URI, part.getName());
            partElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
            root.appendChild(partElement);
        }

        MessageDefinition messageDefinition = MessageDefinition.newFile(name);
        try {
            Writer writer = null;
            try {
                writer = new FileWriter(messageDefinition);
                message.serializeAndConsume(writer);
            } finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
        } catch (Exception ex) {
            throw new IllegalStateException(ex.toString());
        }
        message.setMessageDefinition(messageDefinition);
        return message;

    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.message.default10.DefaultMessageFactory$Provider#spi_createMessage(org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName,
     *      org.xml.sax.EntityResolver, java.io.File, java.lang.String)
     */
    public DefaultMessage spi_createMessage(ComponentName componentName, EntityResolver entityResolver, DOMSource source, String charSet) throws DeploymentException {

        if (source == null) {
            throw new IllegalArgumentException("source null");
        }

        MessageDefinition messageDefinition = null;
        Writer writer = null;
        try {
            Node node = source.getNode();
            DOMImplementation di = node.getOwnerDocument().getImplementation();
            DOMImplementationLS ls = (DOMImplementationLS)di.getFeature("LS", "3.0");
            messageDefinition = MessageDefinition.newFile(componentName);
            FileOutputStream fos = new FileOutputStream(messageDefinition);
            writer = new OutputStreamWriter(fos);
            LSSerializer lsSerializer = ls.createLSSerializer();
            LSOutput destination = ls.createLSOutput();
            destination.setCharacterStream(writer);
            destination.setEncoding("UTF-8");
            lsSerializer.write(node, destination);
        } catch (Exception ex) {
            throw new DeploymentException("Error reading domSource. " + ex);
        } finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                } catch (IOException ie) {
                    throw new DeploymentException(ie);
                }
            }
        }

        DefaultMessageImpl message = null;
        try {
            InputStream in = messageDefinition.newInputStream();
            OMFactory omf = new OMDOMFactoryImpl();
            StAXOMBuilder builder = new StAXOMBuilder(omf, STAXUtils.createXMLStreamReader(in, "UTF-8"));
            message = (DefaultMessageImpl)builder.getDocument();
            message.setComponentName(componentName);
            message.setMessageDefinition(messageDefinition);
        } catch (Exception ex) {
            throw new DeploymentException("Error reading message. " + ex);
        }

        return message;

    }

}
