/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.ext.dependency.maven20.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.StringUtils;

public class InterpolationHelper {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(env\\.)?([^}]+)\\}");
    private static final String EOA_SPEC_HOME_VAR = "${env.EOA_SPEC_HOME}";
    private static final String TRELEIS_HOME_VAR = "${env.TRELEIS_HOME}";

    public static String interpolate(String input) {
        Matcher matcher;
        String result = input;
        if (result.contains(EOA_SPEC_HOME_VAR) && System.getProperty("EOA_SPEC_HOME") == null && System.getProperty("TRELEIS_HOME") != null) {
            result.replace(EOA_SPEC_HOME_VAR, TRELEIS_HOME_VAR);
        }
        if ((matcher = EXPRESSION_PATTERN.matcher(result)).find()) {
            String variable = matcher.group(0);
            String prefix = matcher.group(1);
            String env = matcher.group(2);
            prefix = prefix == null ? "" : prefix;
            String value = System.getenv(env);
            if (value != null) {
                result = StringUtils.replace((String)result, (String)variable, (String)value.toString());
                matcher.reset(result);
            } else {
                throw new IllegalArgumentException("Failed to replace variable " + variable + " within the following pom: " + System.getProperty("line.separator") + input);
            }
        }
        return result;
    }
}

