/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.ext.dependency.maven20;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.WarningResolutionListener;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.resolver.filter.TypeArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.DefaultConfiguration;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.PlexusLoggerAdapter;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.settings.Settings;
import org.bluestemsoftware.open.eoa.ext.dependency.maven20.dependency.AbstractDependency;
import org.bluestemsoftware.open.eoa.ext.dependency.maven20.dependency.AbstractDeploymentDependency;
import org.bluestemsoftware.open.eoa.ext.dependency.maven20.dependency.ComponentDependencyImpl;
import org.bluestemsoftware.open.eoa.ext.dependency.maven20.dependency.FactoryDependencyImpl;
import org.bluestemsoftware.open.eoa.ext.dependency.maven20.dependency.FeatureDependencyImpl;
import org.bluestemsoftware.open.eoa.ext.dependency.maven20.dependency.ModuleDependencyImpl;
import org.bluestemsoftware.open.eoa.ext.dependency.maven20.dependency.ProvidedDependencyImpl;
import org.bluestemsoftware.open.eoa.ext.dependency.maven20.dependency.ScopedDependencyImpl;
import org.bluestemsoftware.open.eoa.ext.dependency.maven20.dependency.SharedDependencyImpl;
import org.bluestemsoftware.open.eoa.ext.dependency.maven20.util.InterpolationHelper;
import org.bluestemsoftware.open.eoa.ext.dependency.maven20.util.MavenEmbedderLogger;
import org.bluestemsoftware.open.eoa.ext.dependency.maven20.util.MavenException;
import org.bluestemsoftware.specification.eoa.ComponentDependency;
import org.bluestemsoftware.specification.eoa.Dependency;
import org.bluestemsoftware.specification.eoa.FactoryDependency;
import org.bluestemsoftware.specification.eoa.FeatureDependency;
import org.bluestemsoftware.specification.eoa.ModuleDependency;
import org.bluestemsoftware.specification.eoa.ProvidedDependency;
import org.bluestemsoftware.specification.eoa.ScopedDependency;
import org.bluestemsoftware.specification.eoa.SharedDependency;
import org.bluestemsoftware.specification.eoa.SystemDependencies;
import org.bluestemsoftware.specification.eoa.ext.ExtensionException;
import org.bluestemsoftware.specification.eoa.ext.dependency.maven20.MavenDependencyManager;
import org.bluestemsoftware.specification.eoa.system.System;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyManagerImpl
extends MavenDependencyManager {
    private static System.Log log = SystemContext.getContext().getSystem().getLog(System.class);
    private MavenEmbedder maven;
    private PlexusContainer mavenContainer;
    private ArtifactFactory artifactFactory;
    private MavenProjectBuilder projectBuilder;
    private ArtifactMetadataSource metadataSource;
    private ArtifactResolver artifactResolver;
    private ArtifactCollector artifactCollector;
    private AndArtifactFilter artifactFilter;
    private OrArtifactFilter moduleTypeFilter;
    private Artifact dummyArtifact;
    private MavenEmbedderLogger embedderLogger;
    private List<ResolutionListener> listeners;
    private File tempDirectory;
    private List<?> remoteRepositories;

    public void init(File settings) throws MavenException {
        log.info("starting maven embedded");
        ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();
        DefaultConfiguration configuration = new DefaultConfiguration();
        configuration.setUserSettingsFile(settings);
        this.embedderLogger = new MavenEmbedderLogger();
        configuration.setMavenEmbedderLogger((org.apache.maven.embedder.MavenEmbedderLogger)this.embedderLogger);
        configuration.setClassLoader(systemClassLoader);
        this.listeners = new ArrayList<ResolutionListener>();
        this.listeners.add((ResolutionListener)new WarningResolutionListener((Logger)new PlexusLoggerAdapter((org.apache.maven.embedder.MavenEmbedderLogger)this.embedderLogger)));
        if (this.embedderLogger.isDebugEnabled()) {
            this.listeners.add((ResolutionListener)new DebugResolutionListener((Logger)new PlexusLoggerAdapter((org.apache.maven.embedder.MavenEmbedderLogger)this.embedderLogger)));
        }
        try {
            this.maven = new MavenEmbedder((Configuration)configuration);
        }
        catch (Exception ex) {
            throw new MavenException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(systemClassLoader);
        }
        this.mavenContainer = this.maven.getPlexusContainer();
        try {
            Settings mavenSettings = this.maven.getSettings();
            WagonManager wagonManager = (WagonManager)this.mavenContainer.lookup(WagonManager.ROLE);
            wagonManager.setOnline(!mavenSettings.isOffline());
        }
        catch (ComponentLookupException ce) {
            throw new MavenException(ce);
        }
        try {
            this.artifactFactory = (ArtifactFactory)this.mavenContainer.lookup(ArtifactFactory.ROLE);
            this.projectBuilder = (MavenProjectBuilder)this.mavenContainer.lookup(MavenProjectBuilder.class);
            this.metadataSource = (ArtifactMetadataSource)this.mavenContainer.lookup(ArtifactMetadataSource.class);
            this.artifactCollector = (ArtifactCollector)this.mavenContainer.lookup(ArtifactCollector.class);
            this.artifactResolver = (ArtifactResolver)this.mavenContainer.lookup(ArtifactResolver.class);
        }
        catch (ComponentLookupException ce) {
            throw new MavenException(ce);
        }
        ScopeArtifactFilter scopeFilter = new ScopeArtifactFilter(Artifact.SCOPE_RUNTIME);
        TypeArtifactFilter typeFilter = new TypeArtifactFilter("jar");
        this.artifactFilter = new AndArtifactFilter();
        this.artifactFilter.add((ArtifactFilter)scopeFilter);
        this.artifactFilter.add((ArtifactFilter)typeFilter);
        this.moduleTypeFilter = new OrArtifactFilter();
        this.moduleTypeFilter.add((ArtifactFilter)new TypeArtifactFilter("eoa-component"));
        this.moduleTypeFilter.add((ArtifactFilter)new TypeArtifactFilter("eoa-factory"));
        this.moduleTypeFilter.add((ArtifactFilter)new TypeArtifactFilter("eoa-feature"));
        this.dummyArtifact = this.artifactFactory.createArtifact("dummy", "dummy", "dummy", Artifact.SCOPE_RUNTIME, "jar");
        this.tempDirectory = SystemContext.getContext().getSystem().getSystemTmpDir();
        log.trace("init end");
    }

    public void destroy() {
        if (this.maven != null) {
            try {
                this.maven.stop();
            }
            catch (MavenEmbedderException ex) {
                log.error("error stopping maven embedded. " + (Object)((Object)ex));
            }
            this.maven = null;
            this.mavenContainer = null;
        }
    }

    public SystemDependencies modelSystemDependencies(File projectDescriptor) throws MavenException {
        MavenProject project;
        log.info("modeling system dependencies");
        if (projectDescriptor == null) {
            throw new IllegalArgumentException("projectDescriptor null");
        }
        try {
            File temp = this.replaceSystemPathVariables(projectDescriptor);
            project = this.maven.readProject(temp);
            temp.deleteOnExit();
            this.remoteRepositories = project.getRemoteArtifactRepositories();
            project.setDependencyArtifacts(this.getProjectDependencies(null, project));
        }
        catch (Exception ex) {
            if (ex instanceof InvalidProjectModelException) {
                throw new MavenException("Error modeling system dependencies. Invalid system POM. " + ((InvalidProjectModelException)ex).getValidationResult().toString());
            }
            throw new MavenException("Error modeling system dependencies. " + ex);
        }
        String organizationID = project.getGroupId();
        String artifactID = project.getArtifactId();
        String version = project.getVersion();
        Set explicitArtifacts = project.getDependencyArtifacts();
        log.info("resolving shared dependencies ...");
        ArrayList<SharedDependencyImpl> sharedDependencies = new ArrayList<SharedDependencyImpl>();
        for (Artifact artifact : explicitArtifacts) {
            if (!artifact.getScope().equals("provided") || !artifact.getType().equals("jar")) continue;
            SharedDependencyImpl sharedDependency = new SharedDependencyImpl(artifact.getFile(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), !artifact.isOptional());
            sharedDependencies.add(sharedDependency);
            log.trace("created shared dependency " + artifact.getArtifactId());
        }
        log.info("resolving factory dependencies ...");
        ArrayList<FactoryDependency> extensionDependencies = new ArrayList<FactoryDependency>();
        for (Artifact artifact : explicitArtifacts) {
            FactoryDependency efd;
            if (!artifact.getScope().equals("runtime") && !artifact.getScope().equals("runtime") || !artifact.getType().equals("eoa-factory") && !artifact.getType().equals("eoa-feature") || extensionDependencies.contains(efd = this.modelFactoryDependency(artifact, project))) continue;
            extensionDependencies.add(efd);
        }
        ArrayList<ComponentDependency> componentDependencies = new ArrayList<ComponentDependency>();
        for (Artifact artifact : explicitArtifacts) {
            ComponentDependency cd;
            if (!artifact.getScope().equals("runtime") || !artifact.getType().equals("eoa-component") || (cd = this.modelComponentDependency(artifact, project, new HashSet<String>(), false)) == null || componentDependencies.contains(cd)) continue;
            componentDependencies.add(cd);
        }
        log.info("modeled system dependencies");
        return new SystemDependencies(organizationID, artifactID, version, sharedDependencies, extensionDependencies, componentDependencies);
    }

    public Dependency resolveDependency(String organizationID, String artifactID, String version, String extension) throws ExtensionException {
        Artifact artifact = this.artifactFactory.createBuildArtifact(organizationID, artifactID, version, extension);
        try {
            this.resolveArtifact(artifact, this.remoteRepositories);
        }
        catch (Exception ex) {
            throw new MavenException("Error resolving dependency. " + ex.getMessage());
        }
        return new AbstractDependency(artifact.getFile(), organizationID, artifactID, version, extension);
    }

    private FactoryDependency modelFactoryDependency(Artifact extensionFactoryArtifact, MavenProject rootProject) throws MavenException {
        ArtifactResolutionResult arr;
        MavenProject extensionFactoryProject;
        if (log.isTraceEnabled()) {
            log.trace("resolving " + extensionFactoryArtifact.getArtifactId() + " ...");
        }
        try {
            extensionFactoryProject = this.modelDependencyProject(extensionFactoryArtifact, rootProject);
        }
        catch (Exception ex) {
            throw new MavenException("Error modeling factory project " + extensionFactoryArtifact.getArtifactId() + ". " + ex);
        }
        Set explicitArtifacts = extensionFactoryProject.getDependencyArtifacts();
        ArrayList<ProvidedDependency> providedDependencies = new ArrayList<ProvidedDependency>();
        for (Artifact artifact : explicitArtifacts) {
            if (!artifact.getScope().equals("system") || !artifact.getType().equals("jar")) continue;
            ProvidedDependencyImpl providedDependency = new ProvidedDependencyImpl(artifact.getFile(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
            providedDependencies.add((ProvidedDependency)providedDependency);
            if (!log.isDebugEnabled()) continue;
            log.debug("created provided dependency " + providedDependency.getRef());
        }
        ArrayList<SharedDependency> sharedDependencies = new ArrayList<SharedDependency>();
        for (Artifact artifact : explicitArtifacts) {
            if (!artifact.getScope().equals("provided") || !artifact.getType().equals("jar") || artifact.isOptional()) continue;
            SharedDependencyImpl sharedDependency = new SharedDependencyImpl(artifact.getFile(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), !artifact.isOptional());
            sharedDependencies.add((SharedDependency)sharedDependency);
            if (!log.isDebugEnabled()) continue;
            log.debug("created shared dependency " + sharedDependency.getRef());
        }
        HashSet<Artifact> scopedArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : explicitArtifacts) {
            if (!artifact.getScope().equals("compile") || !artifact.getType().equals("jar") || !artifact.isOptional()) continue;
            scopedArtifacts.add(artifact);
        }
        try {
            Map<String, Artifact> managedVersionMap = this.createManagedVersionMap(extensionFactoryProject);
            arr = this.artifactCollector.collect(scopedArtifacts, this.dummyArtifact, managedVersionMap, this.maven.getLocalRepository(), extensionFactoryProject.getRemoteArtifactRepositories(), this.metadataSource, (ArtifactFilter)this.artifactFilter, this.listeners);
        }
        catch (Exception ex) {
            throw new MavenException("Error resolving transitive dependencies. " + ex);
        }
        HashSet<Artifact> resolvedArtifacts = new HashSet<Artifact>();
        for (ResolutionNode node : arr.getArtifactResolutionNodes()) {
            try {
                Artifact ra = node.getArtifact();
                this.resolveArtifact(ra, node.getRemoteRepositories());
                resolvedArtifacts.add(ra);
            }
            catch (Exception ex) {
                log.warn("error resolving " + node.getArtifact().toString() + ". " + ex.getMessage());
            }
        }
        ArrayList<ScopedDependency> scopedDependencies = new ArrayList<ScopedDependency>();
        for (Artifact ra : resolvedArtifacts) {
            ScopedDependencyImpl scopedDependency = new ScopedDependencyImpl(ra.getFile(), ra.getGroupId(), ra.getArtifactId(), ra.getVersion(), ra.getType(), ra.getDependencyTrail().toString());
            scopedDependencies.add((ScopedDependency)scopedDependency);
            log.debug("created scoped dependency " + scopedDependency.getRef());
            log.debug("dependency trail: " + ra.getDependencyTrail());
        }
        ArrayList<FeatureDependency> featureDependencies = new ArrayList<FeatureDependency>();
        for (Artifact artifact : explicitArtifacts) {
            FeatureDependency ffd;
            if (!artifact.getScope().equals("runtime") || !artifact.getType().equals("eoa-feature") || featureDependencies.contains(ffd = (FeatureDependency)this.modelFactoryDependency(artifact, rootProject))) continue;
            featureDependencies.add(ffd);
            log.debug("created feature dependency " + ffd.getRef());
        }
        boolean isSnapshot = extensionFactoryArtifact.getVersion().contains("SNAPSHOT");
        File file = this.expandDeploymentArtifact(extensionFactoryArtifact.getFile(), isSnapshot);
        FactoryDependencyImpl factoryDependency = null;
        if (extensionFactoryArtifact.getType().equals("eoa-feature")) {
            boolean isRequired = !extensionFactoryArtifact.isOptional();
            factoryDependency = new FeatureDependencyImpl(file, extensionFactoryArtifact.getGroupId(), extensionFactoryArtifact.getArtifactId(), extensionFactoryArtifact.getVersion(), extensionFactoryArtifact.getType(), isRequired);
        } else {
            factoryDependency = new FactoryDependencyImpl(file, extensionFactoryArtifact.getGroupId(), extensionFactoryArtifact.getArtifactId(), extensionFactoryArtifact.getVersion(), extensionFactoryArtifact.getType());
        }
        ((AbstractDeploymentDependency)factoryDependency).setProvidedDependencies(providedDependencies);
        ((AbstractDeploymentDependency)factoryDependency).setSharedDependencies(sharedDependencies);
        ((AbstractDeploymentDependency)factoryDependency).setScopedDependencies(scopedDependencies);
        ((AbstractDeploymentDependency)factoryDependency).setFeatureDependencies(featureDependencies);
        return factoryDependency;
    }

    private MavenProject modelDependencyProject(Artifact factoryArtifact, MavenProject parentProject) throws Exception {
        String ref = factoryArtifact.getGroupId() + "/" + factoryArtifact.getArtifactId() + "/" + factoryArtifact.getVersion() + "/" + factoryArtifact.getType();
        String dutRef = null;
        if (System.getProperties().get("eoa.system.test.properties") != null) {
            Map testProperties = (Map)System.getProperties().get("eoa.system.test.properties");
            dutRef = testProperties.get("organizationID") + "/" + testProperties.get("artifactID") + "/" + testProperties.get("version") + "/" + testProperties.get("extension");
        }
        MavenProject dependencyProject = null;
        if (dutRef != null && dutRef.equals(ref)) {
            String basedir = System.getProperty("basedir");
            File factoryUnderTestPOM = new File(basedir, "pom.xml");
            factoryUnderTestPOM = this.replaceSystemPathVariables(factoryUnderTestPOM);
            try {
                dependencyProject = this.maven.readProject(factoryUnderTestPOM);
            }
            catch (InvalidProjectModelException ie) {
                throw new MavenException("Error validating POM at location '" + new File(basedir, "pom.xml") + "'. " + ie.getValidationResult());
            }
            factoryUnderTestPOM.deleteOnExit();
            dependencyProject.setDependencyArtifacts(this.getProjectDependencies(factoryArtifact, dependencyProject));
        } else {
            Artifact pomArtifact = this.artifactFactory.createProjectArtifact(factoryArtifact.getGroupId(), factoryArtifact.getArtifactId(), factoryArtifact.getVersion());
            this.resolveArtifact(pomArtifact, parentProject.getRemoteArtifactRepositories());
            File temp = pomArtifact.getFile();
            pomArtifact.setFile(this.replaceSystemPathVariables(temp));
            try {
                dependencyProject = this.projectBuilder.buildFromRepository(pomArtifact, parentProject.getRemoteArtifactRepositories(), this.maven.getLocalRepository());
            }
            catch (InvalidProjectModelException ie) {
                throw new MavenException("Error validating POM at location '" + temp.getAbsolutePath() + "'. " + ie.getValidationResult());
            }
            pomArtifact.getFile().deleteOnExit();
            dependencyProject.setDependencyArtifacts(this.getProjectDependencies(factoryArtifact, dependencyProject));
        }
        return dependencyProject;
    }

    private File replaceSystemPathVariables(File file) throws Exception {
        String input = IOUtils.toString((InputStream)new FileInputStream(file), (String)"UTF-8");
        input = InterpolationHelper.interpolate(input);
        File tempDir = SystemContext.getContext().getSystem().getSystemTmpDir();
        File temp = File.createTempFile("tmp", ".pom", tempDir);
        FileOutputStream out = new FileOutputStream(temp);
        ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes("UTF-8"));
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.flush();
        out.close();
        return temp;
    }

    private ComponentDependency modelComponentDependency(Artifact componentArtifact, MavenProject rootProject, Set<String> processed, boolean isTransitive) throws MavenException {
        MavenProject componentProject;
        String ref = componentArtifact.getGroupId() + "/" + componentArtifact.getArtifactId() + "/" + componentArtifact.getVersion() + "/" + componentArtifact.getType();
        if (processed.contains(ref)) {
            return null;
        }
        log.debug("resolving " + componentArtifact.getArtifactId() + " ...");
        try {
            componentProject = this.modelDependencyProject(componentArtifact, rootProject);
        }
        catch (Exception ex) {
            throw new MavenException("Error modeling component project " + ref + ". " + ex);
        }
        Set explicitArtifacts = componentProject.getDependencyArtifacts();
        ArrayList<ProvidedDependency> providedDependencies = new ArrayList<ProvidedDependency>();
        if (!isTransitive) {
            for (Artifact artifact : explicitArtifacts) {
                if (!artifact.getScope().equals("system") || !artifact.getType().equals("jar")) continue;
                ProvidedDependencyImpl providedDependency = new ProvidedDependencyImpl(artifact.getFile(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
                providedDependencies.add((ProvidedDependency)providedDependency);
                if (!log.isDebugEnabled()) continue;
                log.debug("created provided dependency " + providedDependency.getRef());
            }
        }
        ArrayList<SharedDependency> sharedDependencies = new ArrayList<SharedDependency>();
        if (!isTransitive) {
            for (Artifact artifact : explicitArtifacts) {
                if (!artifact.getScope().equals("provided") || !artifact.getType().equals("jar") || artifact.isOptional()) continue;
                SharedDependencyImpl sharedDependency = new SharedDependencyImpl(artifact.getFile(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), !artifact.isOptional());
                sharedDependencies.add((SharedDependency)sharedDependency);
                if (!log.isDebugEnabled()) continue;
                log.debug("created shared dependency " + sharedDependency.getRef());
            }
        }
        ArrayList<ScopedDependency> scopedDependencies = new ArrayList<ScopedDependency>();
        if (!isTransitive) {
            ArtifactResolutionResult arr;
            HashSet<Artifact> scopedArtifacts = new HashSet<Artifact>();
            for (Artifact artifact : explicitArtifacts) {
                if (!artifact.getScope().equals("compile") || !artifact.getType().equals("jar") || !artifact.isOptional()) continue;
                scopedArtifacts.add(artifact);
            }
            try {
                Map<String, Artifact> managedVersionMap = this.createManagedVersionMap(componentProject);
                arr = this.artifactCollector.collect(scopedArtifacts, this.dummyArtifact, managedVersionMap, this.maven.getLocalRepository(), componentProject.getRemoteArtifactRepositories(), this.metadataSource, (ArtifactFilter)this.artifactFilter, this.listeners);
            }
            catch (Exception ex) {
                throw new MavenException("Error resolving transitive dependencies. " + ex);
            }
            HashSet<Artifact> resolvedArtifacts = new HashSet<Artifact>();
            for (ResolutionNode node : arr.getArtifactResolutionNodes()) {
                try {
                    Artifact ra = node.getArtifact();
                    this.resolveArtifact(ra, node.getRemoteRepositories());
                    resolvedArtifacts.add(ra);
                }
                catch (Exception ex) {
                    log.warn("error resolving " + node.getArtifact().toString() + ". " + ex.getMessage());
                }
            }
            for (Artifact ra : resolvedArtifacts) {
                ScopedDependencyImpl scopedDependency = new ScopedDependencyImpl(ra.getFile(), ra.getGroupId(), ra.getArtifactId(), ra.getVersion(), ra.getType(), ra.getDependencyTrail().toString());
                scopedDependencies.add((ScopedDependency)scopedDependency);
                log.debug("created scoped dependency " + scopedDependency.getRef());
                log.debug("dependency trail: " + ra.getDependencyTrail());
            }
        }
        boolean isSnapshot = componentArtifact.getVersion().contains("SNAPSHOT");
        File file = this.expandDeploymentArtifact(componentArtifact.getFile(), isSnapshot);
        ComponentDependencyImpl cd = new ComponentDependencyImpl(file, componentArtifact.getGroupId(), componentArtifact.getArtifactId(), componentArtifact.getVersion(), componentArtifact.getType());
        ArrayList<ComponentDependency> componentDependencies = new ArrayList<ComponentDependency>();
        if (!componentArtifact.isOptional()) {
            for (Artifact artifact : explicitArtifacts) {
                ComponentDependency temp;
                if (!artifact.getScope().equals("runtime") || !artifact.getType().equals("eoa-component") || (temp = this.modelComponentDependency(artifact, rootProject, processed, true)) == null || componentDependencies.contains(temp)) continue;
                componentDependencies.add(temp);
            }
        }
        ArrayList<FeatureDependency> featureDependencies = new ArrayList<FeatureDependency>();
        if (!isTransitive) {
            for (Artifact artifact : explicitArtifacts) {
                FeatureDependency ffd;
                if (!artifact.getScope().equals("runtime") || !artifact.getType().equals("eoa-feature") || featureDependencies.contains(ffd = (FeatureDependency)this.modelFactoryDependency(artifact, rootProject))) continue;
                featureDependencies.add(ffd);
                log.debug("created feature dependency " + ffd.getRef());
            }
        }
        HashMap<String, ModuleDependency> moduleDependencies = new HashMap<String, ModuleDependency>();
        if (!isTransitive) {
            for (Artifact artifact : explicitArtifacts) {
                if (this.moduleTypeFilter.include(artifact) || !artifact.getScope().equals("runtime")) continue;
                ModuleDependencyImpl moduleDependency = new ModuleDependencyImpl(artifact.getFile(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
                if (moduleDependencies.containsKey(moduleDependency.getVersionlessRef())) {
                    throw new MavenException("More than one version of 'module' dependency " + moduleDependency.getVersionlessRef() + " specified by deployment " + cd.getRef() + ".");
                }
                moduleDependencies.put(moduleDependency.getVersionlessRef(), (ModuleDependency)moduleDependency);
                if (!log.isDebugEnabled()) continue;
                log.debug("created module dependency " + moduleDependency.getRef());
            }
        }
        ((AbstractDeploymentDependency)cd).setProvidedDependencies(providedDependencies);
        ((AbstractDeploymentDependency)cd).setSharedDependencies(sharedDependencies);
        ((AbstractDeploymentDependency)cd).setScopedDependencies(scopedDependencies);
        cd.setComponentDependencies(componentDependencies);
        ((AbstractDeploymentDependency)cd).setFeatureDependencies(featureDependencies);
        cd.setModuleDependencies(moduleDependencies);
        processed.add(ref);
        return cd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Artifact> getProjectDependencies(Artifact dependencyArtifact, MavenProject dependencyProject) throws Exception {
        HashSet<Artifact> projectDependencies = new HashSet<Artifact>();
        for (Object dependencyObj : dependencyProject.getDependencies()) {
            String dutRef;
            String ref;
            Map testProperties;
            org.apache.maven.model.Dependency dependency = (org.apache.maven.model.Dependency)dependencyObj;
            String groupID = dependency.getGroupId();
            String artifactID = dependency.getArtifactId();
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
            String scope = dependency.getScope() == null ? Artifact.SCOPE_COMPILE : dependency.getScope();
            String type = dependency.getType() == null ? "jar" : dependency.getType();
            String classifier = dependency.getClassifier();
            boolean isOptional = dependency.isOptional();
            if (scope.equals("test")) continue;
            Artifact artifact = this.artifactFactory.createDependencyArtifact(groupID, artifactID, versionRange, type, classifier, scope, isOptional);
            if (scope.equals(Artifact.SCOPE_SYSTEM)) {
                File file = new File(dependency.getSystemPath());
                artifact.setFile(file);
            }
            if (dependency.getExclusions() != null) {
                ArrayList<String> patterns = new ArrayList<String>();
                for (Object exclusionObj : dependency.getExclusions()) {
                    Exclusion exclusion = (Exclusion)exclusionObj;
                    StringBuilder sb = new StringBuilder();
                    sb.append(exclusion.getGroupId());
                    sb.append(":");
                    sb.append(exclusion.getArtifactId());
                    patterns.add(sb.toString());
                }
                ExcludesArtifactFilter excludesFilter = new ExcludesArtifactFilter(patterns);
                artifact.setDependencyFilter((ArtifactFilter)excludesFilter);
            }
            if ((testProperties = (Map)System.getProperties().get("eoa.system.test.properties")) != null && (ref = artifact.getGroupId() + "/" + artifact.getArtifactId() + "/" + artifact.getVersion() + "/" + artifact.getType()).equals(dutRef = testProperties.get("organizationID") + "/" + testProperties.get("artifactID") + "/" + testProperties.get("version") + "/" + testProperties.get("extension"))) {
                String basedir = System.getProperty("basedir");
                String archiveName = artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getType();
                artifact.setFile(new File(new File(basedir, "target/"), archiveName));
                projectDependencies.add(artifact);
                continue;
            }
            if (dependencyArtifact != null && !this.moduleTypeFilter.include(artifact) && artifact.getScope().equals("runtime")) {
                String path = artifact.getGroupId() + "/" + artifact.getArtifactId() + "." + artifact.getType();
                File file = dependencyArtifact.getFile();
                if (file.isDirectory()) {
                    File source = new File(file, path);
                    if (!source.exists()) {
                        throw new MavenException("Error resolving 'module' dependency. Dependency must be located within parent project file " + file.getName() + " at path " + path);
                    }
                    artifact.setFile(source);
                } else {
                    ZipFile zipFile = new ZipFile(file);
                    ZipEntry entry = zipFile.getEntry(path);
                    if (entry == null) {
                        throw new MavenException("Error resolving 'module' dependency. Dependency must be located within parent project file " + file.getName() + " at path " + path);
                    }
                    File target = File.createTempFile("eoa-", "." + artifact.getType(), this.tempDirectory);
                    target.deleteOnExit();
                    InputStream in = null;
                    OutputStream out = null;
                    try {
                        in = zipFile.getInputStream(entry);
                        out = new BufferedOutputStream(new FileOutputStream(target));
                        byte[] buffer = new byte[4096];
                        int length = 0;
                        while (length >= 0) {
                            out.write(buffer, 0, length);
                            length = in.read(buffer);
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    artifact.setFile(target);
                }
                projectDependencies.add(artifact);
                continue;
            }
            try {
                this.resolveArtifact(artifact, dependencyProject.getRemoteArtifactRepositories());
                projectDependencies.add(artifact);
            }
            catch (ArtifactNotFoundException ae) {
                if (System.getProperties().get("eoa.system.test.properties") != null) {
                    if (artifact.getType().equals("eoa-component")) {
                        log.warn("Failed to resolve component dependency " + ae.getGroupId() + "/" + ae.getArtifactId() + ":" + ae.getVersion() + " from any repository.");
                        continue;
                    }
                    throw ae;
                }
                throw ae;
            }
        }
        return projectDependencies;
    }

    private void resolveArtifact(Artifact artifact, List<?> remoteRepositories) throws Exception {
        if (artifact.isSnapshot()) {
            String version = artifact.getVersion();
            this.artifactResolver.resolve(artifact, remoteRepositories, this.maven.getLocalRepository());
            artifact.selectVersion(version);
        } else {
            this.artifactResolver.resolve(artifact, remoteRepositories, this.maven.getLocalRepository());
        }
    }

    private File expandDeploymentArtifact(File file, boolean isSnapshot) throws MavenException {
        String name;
        File parent = file.getParentFile();
        File target = new File(parent, (name = file.getName().substring(0, file.getName().lastIndexOf("."))) + ".expanded/");
        if (target.exists()) {
            return target;
        }
        if (isSnapshot) {
            return file;
        }
        try {
            this.unpackArchive(file, target, false);
        }
        catch (Exception ex) {
            throw new MavenException("Unable to expand deployment artifact. " + ex);
        }
        return target;
    }

    private Map<String, Artifact> createManagedVersionMap(MavenProject project) throws InvalidVersionSpecificationException {
        DependencyManagement dependencyManagement = project.getDependencyManagement();
        if (dependencyManagement == null) {
            return Collections.EMPTY_MAP;
        }
        if (dependencyManagement.getDependencies() == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Artifact> managedVersionMap = new HashMap<String, Artifact>();
        for (org.apache.maven.model.Dependency d : dependencyManagement.getDependencies()) {
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
            Artifact artifact = this.artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
            managedVersionMap.put(d.getManagementKey(), artifact);
        }
        return managedVersionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackArchive(File archive, File outputDir, boolean isDestinationTemporary) throws Exception {
        outputDir.mkdir();
        if (isDestinationTemporary) {
            outputDir.deleteOnExit();
        }
        ZipFile zipFile = new ZipFile(archive);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File file = new File(outputDir, File.separator + entry.getName());
                if (entry.isDirectory()) {
                    this.mkdirs(file);
                    continue;
                }
                InputStream in = null;
                OutputStream out = null;
                try {
                    in = zipFile.getInputStream(entry);
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] buffer = new byte[4096];
                    int length = 0;
                    while (length >= 0) {
                        out.write(buffer, 0, length);
                        length = in.read(buffer);
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                if (!isDestinationTemporary) continue;
                file.deleteOnExit();
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private void mkdirs(File child) {
        if (!child.exists()) {
            child.mkdir();
            child.deleteOnExit();
        }
        for (File parent = child.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
            parent.mkdir();
            parent.deleteOnExit();
        }
    }

    static class OrArtifactFilter
    implements ArtifactFilter {
        private final List<ArtifactFilter> filters = new ArrayList<ArtifactFilter>();

        OrArtifactFilter() {
        }

        public boolean include(Artifact artifact) {
            boolean include = false;
            for (ArtifactFilter filter : this.filters) {
                if (!filter.include(artifact)) continue;
                include = true;
                break;
            }
            return include;
        }

        public void add(ArtifactFilter artifactFilter) {
            this.filters.add(artifactFilter);
        }
    }
}

