/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.ext.dependency.maven20.dependency;

import java.io.File;
import org.bluestemsoftware.specification.eoa.Dependency;

public class AbstractDependency
implements Dependency {
    protected File file;
    protected String organizationID;
    protected String artifactID;
    protected String version;
    protected String extension;

    public AbstractDependency(File file, String organizationID, String artifactID, String version, String extension) {
        if (file == null) {
            throw new IllegalArgumentException("file null");
        }
        if (organizationID == null) {
            throw new IllegalArgumentException("organizationID null");
        }
        if (artifactID == null) {
            throw new IllegalArgumentException("artifactID null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("extension null");
        }
        this.file = file;
        this.organizationID = organizationID;
        this.artifactID = artifactID;
        this.version = version;
        this.extension = extension;
    }

    public final String getRef() {
        return this.organizationID + "/" + this.artifactID + "/" + this.version + "/" + this.extension;
    }

    public final String getVersionlessRef() {
        return this.organizationID + "/" + this.artifactID + "/" + this.extension;
    }

    public final String getShortName() {
        if (this.artifactID == null) {
            throw new IllegalStateException("Error generating short name. 'artifactID' not defined");
        }
        if (this.version == null) {
            throw new IllegalStateException("Error generating short name. 'version' not defined");
        }
        if (this.extension == null) {
            throw new IllegalStateException("Error generating short name. 'extension' not defined");
        }
        return this.artifactID + ":" + this.version + ":" + this.extension;
    }

    public final String getOrganizationID() {
        return this.organizationID;
    }

    public final String getArtifactID() {
        return this.artifactID;
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getExtension() {
        return this.extension;
    }

    public final File getFile() {
        return this.file;
    }

    public final String toString() {
        return this.getRef();
    }

    public final int hashCode() {
        return this.hashCode(this.getRef());
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Dependency)) {
            return false;
        }
        return this.getRef() == ((Dependency)obj).getRef() || this.getRef() != null && this.getRef().equals(((Dependency)obj).getRef());
    }

    private int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }
}

