/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.connector.db.derby.embedded;

import java.util.Properties;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;

import org.apache.commons.beanutils.BeanUtils;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory;
import org.bluestemsoftware.specification.eoa.ext.connector.ConnectorException;
import org.bluestemsoftware.specification.eoa.ext.connector.db.DataSourceConnector;
import org.bluestemsoftware.specification.eoa.ext.connector.db.DataSourceConnectorFactory;
import org.bluestemsoftware.specification.eoa.system.container.ConnectionSupport;

public final class DataSourceConnectorFactoryImpl implements DataSourceConnectorFactory.Provider {

    private static final long serialVersionUID = 1L;

    public static String NAME = "derby-embedded-datasource";
    
    public DataSourceConnectorFactoryImpl() {
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.connector.ConnectorFactory$Provider#spi_getConnectorImpl()
     */
    public String spi_getConnectorImpl() {
        return DataSourceConnectorImpl.IMPL;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.ExtensionFactory)
     */
    public void spi_setConsumer(ExtensionFactory consumer) {
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.connector.ConnectorFactory$Provider#spi_createConnector(java.lang.String, boolean, org.bluestemsoftware.specification.eoa.system.container.ConnectionSupport, java.util.Properties, boolean)
     */
    public DataSourceConnector.Provider spi_createConnector(String name, ConnectionSupport connectionSupport, Properties properties, boolean isXA) throws ConnectorException {

        ManagedConnectionFactory managedConnectionFactory = new ManagedConnectionFactoryImpl(isXA);

        if (properties != null) {
            try {
                BeanUtils.populate(managedConnectionFactory, properties);
            } catch (Throwable th) {
                throw new ConnectorException("Error setting properties on Connector of type '"
                        + DataSourceConnector.TYPE
                        + "' and impl '"
                        + DataSourceConnectorImpl.IMPL
                        + "'. "
                        + th);
            }
        }

        DataSource dataSource = null;
        try {
            dataSource = (DataSource)managedConnectionFactory.createConnectionFactory((ConnectionManager)connectionSupport);
        } catch (ResourceException re) {
            throw new ConnectorException("Error creating connector. " + re);
        }

        return new DataSourceConnectorImpl(dataSource);

    }

}
