/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.client.util;

import org.apache.axiom.soap.SOAPEnvelope;

public class HTTPCallback {

    private String messageID;
    private SOAPEnvelope response;
    private Exception exception;
    private boolean isComplete;
    
    public HTTPCallback(String messageID) {
        this.messageID = messageID;
    }
    
    public String getMessageID() {
        return messageID;
    }

    public synchronized void onComplete() {
        isComplete = true;
        this.notifyAll();
    }

    public void setResponse(SOAPEnvelope response) {
        this.response = response;
    }

    public Exception getException() {
        return exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public synchronized boolean isComplete() {
        return isComplete;
    }

    public SOAPEnvelope getResponse() {
        return response;
    }

}
