/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.test.client.cfg;

import java.io.File;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.ListenerManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.bluestemsoftware.open.eoa.test.client.cfg.ClientConfiguration;
import org.bluestemsoftware.open.eoa.test.client.util.AxisConfiguratorImpl;
import org.bluestemsoftware.open.eoa.test.client.util.SetupException;

public class AbstractClientConfiguration
implements ClientConfiguration {
    private Logger log;
    protected File baseDir;
    protected File resourcesDir;
    protected File classesDir;
    protected static ConfigurationContext configurationContext;

    public boolean setUp() throws Exception {
        this.baseDir = new File(System.getProperty("basedir"));
        this.classesDir = new File(this.baseDir, "target/classes");
        this.resourcesDir = new File(System.getProperty("testClassesDirectory"));
        boolean axisDirectoryExists = this.configureLogging();
        if (axisDirectoryExists) {
            this.configureAxis();
            configurationContext.getListenerManager().start();
        }
        this.log.info((Object)"configuration completed successfully");
        return true;
    }

    public boolean destroy() {
        try {
            if (configurationContext != null) {
                configurationContext.cleanupContexts();
                configurationContext.terminate();
            }
            return true;
        }
        catch (AxisFault af) {
            if (this.log != null) {
                this.log.error((Object)("error destroying client configuration. " + (Object)((Object)af)));
            }
            return false;
        }
    }

    public static ConfigurationContext getConfigurationContext() {
        return configurationContext;
    }

    private boolean configureAxis() throws Exception {
        this.log.info((Object)"configuring axis");
        URL conf = new File(this.resourcesDir, "axis/conf/axis2.xml").toURI().toURL();
        URL repo = new File(this.resourcesDir, "axis/").toURI().toURL();
        AxisConfiguratorImpl ac = new AxisConfiguratorImpl(conf, repo);
        configurationContext = ConfigurationContextFactory.createConfigurationContext((AxisConfigurator)ac);
        new ListenerManager().init(configurationContext);
        return true;
    }

    private boolean configureLogging() throws Exception {
        File loggingConfig = null;
        boolean axisDirectoryExists = false;
        File axisDir = new File(this.resourcesDir, "axis/");
        if (axisDir.exists()) {
            axisDirectoryExists = true;
            loggingConfig = new File(axisDir, "conf/log4j.xml");
        } else {
            loggingConfig = new File(this.resourcesDir, "log4j.xml");
            if (!loggingConfig.exists()) {
                loggingConfig = new File(this.resourcesDir, "conf/log4j.xml");
            }
        }
        if (!loggingConfig.exists()) {
            throw new SetupException("missing logging configuration " + loggingConfig.getCanonicalPath());
        }
        DOMConfigurator.configure((String)loggingConfig.getCanonicalPath());
        System.setProperty("org.apache.commons.logging.LogFactory", "org.apache.commons.logging.impl.LogFactoryImpl");
        this.log = Logger.getLogger(ClientConfiguration.class);
        return axisDirectoryExists;
    }
}

