/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.test.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisConfiguratorImpl
extends DeploymentEngine
implements AxisConfigurator {
    private URL conf;
    private URL repo;

    public AxisConfiguratorImpl(URL conf, URL repo) {
        this.conf = conf;
        this.repo = repo;
    }

    public void engageGlobalModules() throws AxisFault {
        this.loadRepositoryFromURL(this.repo);
        this.engageModules();
    }

    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        AxisConfiguration config = null;
        try {
            config = this.populateAxisConfiguration(this.conf.openStream());
        }
        catch (Exception ex) {
            throw new AxisFault("Error retrieving axis2 configuration. " + ex);
        }
        return config;
    }

    public void loadServices() {
        this.loadServicesFromUrl(this.repo);
    }

    protected ArrayList<?> populateService(AxisServiceGroup serviceGroup, URL servicesURL, String serviceName) throws DeploymentException {
        try {
            serviceGroup.setServiceGroupName(serviceName);
            servicesURL = new URL(servicesURL.toString() + "/");
            ClassLoader serviceClassLoader = Utils.createClassLoader((URL[])new URL[]{servicesURL}, (ClassLoader)this.axisConfig.getServiceClassLoader(), (boolean)false, null);
            serviceGroup.setServiceGroupClassLoader(serviceClassLoader);
            HashMap servicesMap = new HashMap();
            InputStream servicexmlStream = serviceClassLoader.getResourceAsStream("META-INF/services.xml");
            if (servicexmlStream == null) {
                servicexmlStream = serviceClassLoader.getResourceAsStream("meta-inf/services.xml");
            }
            if (servicexmlStream == null) {
                throw new DeploymentException(Messages.getMessage((String)"servicexmlnotfound", (String)servicesURL.toString()));
            }
            DescriptionBuilder builder = new DescriptionBuilder(servicexmlStream, this.configContext);
            OMElement rootElement = builder.buildOM();
            String elementName = rootElement.getLocalName();
            if ("service".equals(elementName)) {
                AxisService axisService = new AxisService(serviceName);
                axisService.setParent(serviceGroup);
                axisService.setClassLoader(serviceClassLoader);
                ServiceBuilder serviceBuilder = new ServiceBuilder(this.configContext, axisService);
                AxisService service = serviceBuilder.populateService(rootElement);
                ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
                serviceList.add(service);
                return serviceList;
            }
            if ("serviceGroup".equals(elementName)) {
                ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, servicesMap, this.configContext);
                return groupBuilder.populateServiceGroup(serviceGroup);
            }
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException((Throwable)e);
        }
        return null;
    }
}

