/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.test.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExecutionContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.bluestemsoftware.open.eoa.test.client.util.HTTPCallback;

public class HTTPCallbackServer {
    public static final String MESSAGE_ID = "messageID";
    private Listener listener;
    private boolean shutdown = true;
    private HttpParams params;
    private HttpProcessor httpProcessor;
    private HttpResponseFactory rf;
    private ConnectionReuseStrategy crs;
    private Map<String, HTTPCallback> callbacks;

    public HTTPCallbackServer(int port, int readTimeout) throws IOException {
        ServerSocket serverSocket = new ServerSocket(port);
        serverSocket.setReuseAddress(true);
        this.listener = new Listener(serverSocket);
        this.listener.setDaemon(false);
        this.params = new BasicHttpParams();
        this.params.setIntParameter("http.socket.timeout", readTimeout);
        this.params.setIntParameter("http.socket.buffer-size", 8192);
        this.params.setBooleanParameter("http.connection.stalecheck", false);
        this.params.setBooleanParameter("http.tcp.nodelay", true);
        this.crs = new DefaultConnectionReuseStrategy();
        this.rf = new DefaultHttpResponseFactory();
        this.httpProcessor = new BasicHttpProcessor();
        ((BasicHttpProcessor)this.httpProcessor).addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        ((BasicHttpProcessor)this.httpProcessor).addInterceptor((HttpResponseInterceptor)new ResponseServer());
        ((BasicHttpProcessor)this.httpProcessor).addInterceptor((HttpResponseInterceptor)new ResponseDate());
        ((BasicHttpProcessor)this.httpProcessor).addInterceptor((HttpResponseInterceptor)new ResponseContent());
        this.callbacks = new HashMap<String, HTTPCallback>();
        this.callbacks = Collections.synchronizedMap(this.callbacks);
    }

    public void registerCallback(HTTPCallback callback) {
        this.callbacks.put(callback.getMessageID(), callback);
    }

    public synchronized void start() {
        if (this.shutdown) {
            this.listener.start();
            this.shutdown = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.listener.shutdown();
        Listener listener = this.listener;
        synchronized (listener) {
            while (!this.shutdown) {
                try {
                    this.listener.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class RequestHandlerImpl
    implements HttpRequestHandler {
        RequestHandlerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(HttpRequest request, HttpResponse httpResponse, HttpContext ctxt) throws HttpException, IOException {
            String messageID = null;
            try {
                URI requestURI = new URI(request.getRequestLine().getUri());
                String queryString = requestURI.getQuery();
                if (queryString == null) {
                    return;
                }
                Properties params = new Properties();
                params.load(new StringReader(queryString));
                messageID = params.getProperty(HTTPCallbackServer.MESSAGE_ID);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            HTTPCallback callback = (HTTPCallback)HTTPCallbackServer.this.callbacks.remove(messageID);
            if (callback == null) {
                return;
            }
            XMLStreamReader reader = null;
            try {
                Header header = request.getFirstHeader("Content-Type");
                String contentType = header == null ? "text/plain" : header.getValue();
                SOAPFactory factory = this.getSOAPFactory(contentType);
                HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
                InputStream in = entity.getContent();
                reader = StAXUtils.createXMLStreamReader((InputStream)in, (String)"utf-8");
                StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(reader, factory, null);
                SOAPEnvelope se = (SOAPEnvelope)builder.getDocumentElement();
                se.build();
                callback.setResponse(se);
                Iterator headerItr = request.headerIterator();
                HashMap<String, String> headers = new HashMap<String, String>();
                while (headerItr.hasNext()) {
                    Header temp = (Header)headerItr.next();
                    headers.put(temp.getName(), temp.getValue());
                }
                callback.setHttpHeaders(headers);
            }
            catch (Exception ex) {
                callback.setException(ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException ignore) {}
                }
                callback.onComplete();
            }
        }

        private SOAPFactory getSOAPFactory(String contentType) throws HttpException {
            String mediaType = null;
            int index = contentType.indexOf(59);
            mediaType = index > 0 ? contentType.substring(0, index) : contentType;
            if (mediaType.equals("text/xml")) {
                return OMAbstractFactory.getSOAP11Factory();
            }
            if (mediaType.equals("application/soap+xml")) {
                return OMAbstractFactory.getSOAP12Factory();
            }
            throw new HttpException("Unrecognized media type " + mediaType);
        }
    }

    class Worker
    extends Thread {
        private Socket socket;

        public Worker(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DefaultHttpServerConnection conn = null;
            try {
                conn = new DefaultHttpServerConnection();
                conn.bind(this.socket, HTTPCallbackServer.this.params);
                HttpRequestHandlerRegistry reqistry = new HttpRequestHandlerRegistry();
                reqistry.register("*", (HttpRequestHandler)new RequestHandlerImpl());
                HttpService httpService = new HttpService(HTTPCallbackServer.this.httpProcessor, HTTPCallbackServer.this.crs, HTTPCallbackServer.this.rf);
                httpService.setParams(HTTPCallbackServer.this.params);
                httpService.setHandlerResolver((HttpRequestHandlerResolver)reqistry);
                while (!Worker.interrupted() && conn.isOpen()) {
                    httpService.handleRequest((HttpServerConnection)conn, (HttpContext)new HttpExecutionContext(null));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    conn.shutdown();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    class Listener
    extends Thread {
        private ServerSocket serverSocket;

        public Listener(ServerSocket serverSocket) {
            super("CallackServerListener");
            this.serverSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.serverSocket.isClosed()) {
                try {
                    Socket socket = this.serverSocket.accept();
                    Thread t = new Thread((Runnable)new Worker(socket), "CallbackServerWorker");
                    t.setDaemon(true);
                    t.start();
                }
                catch (SocketException se) {
                    break;
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                    break;
                }
            }
            Listener listener = this;
            synchronized (listener) {
                HTTPCallbackServer.this.shutdown = true;
                this.notify();
            }
        }

        public void shutdown() {
            try {
                this.serverSocket.close();
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
    }
}

