/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.client.cfg;

import java.io.File;
import java.net.URL;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.ListenerManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.bluestemsoftware.open.eoa.test.client.util.AxisConfiguratorImpl;
import org.bluestemsoftware.open.eoa.test.client.util.SetupException;

public class AbstractClientConfiguration implements ClientConfiguration {

    private Logger log;

    protected File baseDir;
    protected File resourcesDir;
    protected File classesDir;
    protected static ConfigurationContext configurationContext;

    public boolean setUp() throws Exception {
        baseDir = new File(System.getProperty("basedir"));
        classesDir = new File(baseDir, "target/classes");
        resourcesDir = new File(java.lang.System.getProperty("testClassesDirectory"));
        boolean axisDirectoryExists = configureLogging();
        if (axisDirectoryExists) {
            configureAxis();
            configurationContext.getListenerManager().start();
        }
        log.info("configuration completed successfully");
        return true;
    }

    public boolean destroy() {
        try {
            if (configurationContext != null) {
                configurationContext.cleanupContexts();
                configurationContext.terminate();
            }
            return true;
        } catch (AxisFault af) {
            if (log != null) {
                log.error("error destroying client configuration. " + af);
            }
            return false;
        }
    }

    public static ConfigurationContext getConfigurationContext() {
        return configurationContext;
    }

    private boolean configureAxis() throws Exception {
        log.info("configuring axis");
        URL conf = new File(resourcesDir, "axis/conf/axis2.xml").toURI().toURL();
        URL repo = new File(resourcesDir, "axis/").toURI().toURL();
        AxisConfigurator ac = new AxisConfiguratorImpl(conf, repo);
        configurationContext = ConfigurationContextFactory.createConfigurationContext(ac);
        new ListenerManager().init(configurationContext);
        return true;
    }

    private boolean configureLogging() throws Exception {
        File loggingConfig = null;
        boolean axisDirectoryExists = false;
        File axisDir = new File(resourcesDir, "axis/");
        if (axisDir.exists()) {
            axisDirectoryExists = true;
            loggingConfig = new File(axisDir, "conf/log4j.xml");
        } else {
            loggingConfig = new File(resourcesDir, "log4j.xml");
            if (!loggingConfig.exists()) {
                loggingConfig = new File(resourcesDir, "conf/log4j.xml");
            }
        }
        if (!loggingConfig.exists()) {
            throw new SetupException("missing logging configuration " + loggingConfig.getCanonicalPath());
        } else {
            DOMConfigurator.configure(loggingConfig.getCanonicalPath());
            System.setProperty("org.apache.commons.logging.LogFactory",
                    "org.apache.commons.logging.impl.LogFactoryImpl");
        }
        log = Logger.getLogger(ClientConfiguration.class);
        return axisDirectoryExists;
    }

}
