/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.expression;

import java.lang.reflect.Method;
import java.util.Map;

import org.bluestemsoftware.open.eoa.test.system.util.MockExtensionProviderFactory;
import org.bluestemsoftware.specification.eoa.ext.ExtensionException;
import org.bluestemsoftware.specification.eoa.ext.expression.xpath.XPathException;
import org.bluestemsoftware.specification.eoa.ext.expression.xpath.xpath10.XPathExpression;
import org.bluestemsoftware.specification.eoa.ext.expression.xpath.xpath10.XPathExpressionFactory;

public class XPathExpressionFactoryProvider implements XPathExpressionFactory.Provider {

    public static final String NAME = "xpath-expression-test";

    private MockExtensionProviderFactory mockExtensionProviderFactory;

    public XPathExpressionFactoryProvider(MockExtensionProviderFactory mockExtensionProviderFactory) {
        this.mockExtensionProviderFactory = mockExtensionProviderFactory;
    }

    public MockExtensionProviderFactory getMockExtensionProviderFactory() {
        return mockExtensionProviderFactory;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.expression.xpath.xpath10.XPathExpressionFactory$Provider#spi_createExpression(java.lang.String)
     */
    public org.bluestemsoftware.specification.eoa.ext.expression.xpath.xpath10.XPathExpression.Provider spi_createExpression(String query) throws XPathException {
        Class<?>[] signature = new Class[] { String.class };
        Method method = null;
        try {
            method = XPathExpressionFactory.Provider.class.getMethod("spi_createExpression", signature);
        } catch (Exception fatchance) {
        }
        Object[] args = new Object[] { query };
        try {
            return (XPathExpression.Provider)mockExtensionProviderFactory.createExtensionProvider(method, args);
        } catch (ExtensionException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.expression.xpath.xpath10.XPathExpressionFactory$Provider#spi_createExpression(java.util.Map, java.lang.String)
     */
    public org.bluestemsoftware.specification.eoa.ext.expression.xpath.xpath10.XPathExpression.Provider spi_createExpression(Map<String, String> namespaces, String query) throws XPathException {
        Class<?>[] signature = new Class[] { Map.class, String.class };
        Method method = null;
        try {
            method = XPathExpressionFactory.Provider.class.getMethod("spi_createExpression", signature);
        } catch (Exception fatchance) {
        }
        Object[] args = new Object[] { namespaces, query };
        try {
            return (XPathExpression.Provider)mockExtensionProviderFactory.createExtensionProvider(method, args);
        } catch (ExtensionException ex) {
            throw new RuntimeException(ex);
        }
    }

}
