/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.message;

import java.lang.reflect.Method;

import javax.xml.transform.dom.DOMSource;

import org.bluestemsoftware.open.eoa.test.system.util.MockExtensionProviderFactory;
import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.component.message.InterfaceMessage;
import org.bluestemsoftware.specification.eoa.ext.ExtensionException;
import org.bluestemsoftware.specification.eoa.ext.message.default10.DefaultMessage;
import org.bluestemsoftware.specification.eoa.ext.message.default10.DefaultMessageFactory;
import org.xml.sax.EntityResolver;

public class DefaultMessageFactoryProvider implements DefaultMessageFactory.Provider {

    public static final String NAME = "default-message-test";

    private MockExtensionProviderFactory mockExtensionProviderFactory;

    public DefaultMessageFactoryProvider(MockExtensionProviderFactory mockExtensionProviderFactory) {
        this.mockExtensionProviderFactory = mockExtensionProviderFactory;
    }

    public MockExtensionProviderFactory getMockExtensionProviderFactory() {
        return mockExtensionProviderFactory;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getExtensionType()
     */
    public String spi_getExtensionType() {
        return DefaultMessage.TYPE;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.message.default10.DefaultMessageFactory$Provider#spi_createDefaultMessage(org.bluestemsoftware.specification.eoa.component.message.InterfaceMessage)
     */
    public DefaultMessage spi_createDefaultMessage(InterfaceMessage runtimeProvidable) {
        Class<?>[] signature = new Class[] {InterfaceMessage.class};
        Method method = null;
        try {
            method = DefaultMessageFactory.Provider.class.getMethod("spi_createDefaultMessage", signature);
        } catch (Exception fatchance) {
        }
        Object[] args = new Object[] {runtimeProvidable};
        try {
            return (DefaultMessage)mockExtensionProviderFactory.createExtensionProvider(method, args);
        } catch (ExtensionException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.message.default10.DefaultMessageFactory$Provider#spi_createMessage(org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName, org.xml.sax.EntityResolver, java.io.File, java.lang.String)
     */
    public DefaultMessage spi_createMessage(ComponentName componentName, EntityResolver entityResolver, DOMSource source, String charSet) throws DeploymentException {
        Class<?>[] signature = new Class[] {ComponentName.class, EntityResolver.class, DOMSource.class, String.class};
        Method method = null;
        try {
            method = DefaultMessageFactory.Provider.class.getMethod("spi_createMessage", signature);
        } catch (Exception fatchance) {
        }
        Object[] args = new Object[] {componentName, entityResolver, source, charSet};
        try {
            return (DefaultMessage)mockExtensionProviderFactory.createExtensionProvider(method, args);
        } catch (ExtensionException ex) {
            throw new RuntimeException(ex);
        }
    }

}
