/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system;

import java.io.File;

import org.bluestemsoftware.specification.eoa.system.SystemContext;

/**
 * Extended by tests which execute within context of INTEGRATION TESTING framework and which
 * test <code>Extension</code> implementations. Appropriate in situations where descendant
 * tests rely upon existence of other 'real' extension objects, i.e. rather than, or in
 * addition to, mock and/or stubbed extensions, all of which are provided within the context of
 * a fully functional EOA system.
 */
public abstract class AbstractIntegrationTest {

    protected org.bluestemsoftware.specification.eoa.system.System system;

    protected String myOrganizationID;
    protected String myArtifactID;
    protected String myExtension;
    protected String myVersion;

    protected File baseDir;
    protected File resourcesDir;
    protected File classesDir;
    
    protected void setUp() throws Exception {

        // retrieve system properties set by surefire booter which identify
        // the 'deployment under test'
        
        myOrganizationID = java.lang.System.getProperty("eoa.system.dut.groupid");
        myArtifactID = java.lang.System.getProperty("eoa.system.dut.artifactid");
        myExtension = java.lang.System.getProperty("eoa.system.dut.packaging");
        myVersion = java.lang.System.getProperty("eoa.system.dut.version");

        baseDir = new File(System.getProperty("basedir"));
        classesDir = new File(baseDir, "target/classes");
        resourcesDir = new File(java.lang.System.getProperty("testClassesDirectory"));
        
        system = SystemContext.getContext().getSystem();

    }

    protected void tearDown() throws Exception {
    }

}
