/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.binding;

import java.lang.reflect.Method;

import org.bluestemsoftware.open.eoa.test.system.util.MockExtensionProviderFactory;
import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.ext.ExtensionException;
import org.bluestemsoftware.specification.eoa.ext.binding.http.HTTPBinding;
import org.bluestemsoftware.specification.eoa.ext.binding.http.HTTPBindingFactory;
import org.bluestemsoftware.specification.eoa.ext.binding.http.rt.HTTPBindingConfiguration;
import org.bluestemsoftware.specification.eoa.ext.binding.http.rt.HTTPBindingRT;

/**
 * Factory which delegates to user defined <code>MockExtensionProviderFactory</code>. 
 */
public class HTTPBindingFactoryProvider implements HTTPBindingFactory.Provider {

    public static final String NAME = "http-binding-test";

    private MockExtensionProviderFactory mockExtensionProviderFactory;

    public HTTPBindingFactoryProvider(MockExtensionProviderFactory mockExtensionProviderFactory) {
        this.mockExtensionProviderFactory = mockExtensionProviderFactory;
    }

    public MockExtensionProviderFactory getMockExtensionProviderFactory() {
        return mockExtensionProviderFactory;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getExtensionType()
     */
    public String spi_getExtensionType() {
        return HTTPBinding.TYPE;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.binding.soap.HTTPBindingFactory$Provider#spi_createProvider(org.bluestemsoftware.specification.eoa.ext.binding.soap.HTTPBindingFactory, org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName, java.lang.String, org.w3c.dom.Element)
     */
    public HTTPBindingRT.Provider spi_createProvider(HTTPBindingFactory factory, ComponentName componentName, String protocolType, HTTPBindingConfiguration hbc) throws DeploymentException {
        Method method = null;
        try {
            Class<?>[] signature = new Class[] {HTTPBindingFactory.class, ComponentName.class, String.class, HTTPBindingConfiguration.class };
            method = HTTPBindingFactory.Provider.class.getMethod("spi_createBinding", signature);
        } catch (Exception fatchance) {
        }
        try {
            Object[] args = new Object[]{factory, componentName, protocolType, hbc};
            return (HTTPBindingRT.Provider)mockExtensionProviderFactory.createExtensionProvider(method, args);
        } catch (ExtensionException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.binding.soap.HTTPBindingFactory$Provider#spi_createDefaultProvider(org.bluestemsoftware.specification.eoa.ext.binding.soap.HTTPBindingFactory, org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName, java.lang.String)
     */
    public HTTPBindingRT.Provider spi_createDefaultProvider(HTTPBindingFactory factory, ComponentName componentName, String protocolType) throws DeploymentException {
        Method method = null;
        try {
            Class<?>[] signature = new Class[] {HTTPBindingFactory.class, ComponentName.class, String.class};
            method = HTTPBindingFactory.Provider.class.getMethod("spi_createDefaultProvider", signature);
        } catch (Exception fatchance) {
        }
        try {
            Object[] args = new Object[]{factory, componentName, protocolType};
            return (HTTPBindingRT.Provider)mockExtensionProviderFactory.createExtensionProvider(method, args);
        } catch (ExtensionException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.binding.BindingFactory$Provider#spi_getBindingImpl()
     */
    public String spi_getBindingImpl() {
        
       // used to identify provider reader for rt binding defs. note
       // that because test may reference component dependencies which
       // contain real deployments, we return default http binding
       // impl 
        
       return "http://bluestemsoftware.org/specification/eoa/ext/binding/http/default/1.0";
       
    }

}
