/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.binding;

import java.lang.reflect.Method;
import java.util.Set;

import org.bluestemsoftware.open.eoa.test.system.util.MockExtensionProviderFactory;
import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.ext.ExtensionException;
import org.bluestemsoftware.specification.eoa.ext.binding.soap.SOAPBinding;
import org.bluestemsoftware.specification.eoa.ext.binding.soap.SOAPBindingFactory;
import org.bluestemsoftware.specification.eoa.ext.binding.soap.rt.SOAPBindingConfiguration;
import org.bluestemsoftware.specification.eoa.ext.binding.soap.rt.SOAPBindingRT;

public class SOAPBindingFactoryProvider implements SOAPBindingFactory.Provider {

    public static final String NAME = "soap-binding-test";

    private MockExtensionProviderFactory mockExtensionProviderFactory;

    public SOAPBindingFactoryProvider(MockExtensionProviderFactory mockExtensionProviderFactory) {
        this.mockExtensionProviderFactory = mockExtensionProviderFactory;
    }

    public MockExtensionProviderFactory getMockExtensionProviderFactory() {
        return mockExtensionProviderFactory;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getExtensionType()
     */
    public String spi_getExtensionType() {
        return SOAPBinding.TYPE;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.binding.soap.SOAPBindingFactory$Provider#spi_createProvider(org.bluestemsoftware.specification.eoa.ext.binding.soap.SOAPBindingFactory, org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName, java.lang.String, org.w3c.dom.Element)
     */
    public SOAPBindingRT.Provider spi_createProvider(SOAPBindingFactory factory, ComponentName componentName, String protocolType, Set<String> features, SOAPBindingConfiguration sbc) throws DeploymentException {
        Method method = null;
        try {
            Class<?>[] signature = new Class[] {SOAPBindingFactory.class, ComponentName.class, String.class, Set.class, SOAPBindingConfiguration.class };
            method = SOAPBindingFactory.Provider.class.getMethod("spi_createBinding", signature);
        } catch (Exception fatchance) {
        }
        try {
            Object[] args = new Object[]{factory, componentName, protocolType, features, sbc};
            return (SOAPBindingRT.Provider)mockExtensionProviderFactory.createExtensionProvider(method, args);
        } catch (ExtensionException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.binding.soap.SOAPBindingFactory$Provider#spi_createDefaultProvider(org.bluestemsoftware.specification.eoa.ext.binding.soap.SOAPBindingFactory, org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName, java.lang.String)
     */
    public SOAPBindingRT.Provider spi_createDefaultProvider(SOAPBindingFactory factory, ComponentName componentName, String protocolType) throws DeploymentException {
        Method method = null;
        try {
            Class<?>[] signature = new Class[] {SOAPBindingFactory.class, ComponentName.class, String.class};
            method = SOAPBindingFactory.Provider.class.getMethod("spi_createDefaultProvider", signature);
        } catch (Exception fatchance) {
        }
        try {
            Object[] args = new Object[]{factory, componentName, protocolType};
            return (SOAPBindingRT.Provider)mockExtensionProviderFactory.createExtensionProvider(method, args);
        } catch (ExtensionException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.binding.BindingFactory$Provider#spi_getBindingImpl()
     */
    public String spi_getBindingImpl() {
       
        // used to identify provider reader for rt binding defs. note
        // that because test may reference component dependencies which
        // contain real deployments, we return default http binding
        // impl 
         
        return "http://bluestemsoftware.org/specification/eoa/ext/binding/soap/default/1.0";
         
        
    }

}
