/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.dependency;

import java.util.Collections;
import java.util.List;

import org.bluestemsoftware.specification.eoa.FeatureDependency;
import org.bluestemsoftware.specification.eoa.ProvidedDependency;
import org.bluestemsoftware.specification.eoa.ScopedDependency;
import org.bluestemsoftware.specification.eoa.SharedDependency;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory.Provider;

public class AbstractFactoryDependency extends AbstractDependency {
    
    private List<ProvidedDependency> providedDependencies;
    private List<SharedDependency> sharedDependencies;
    private List<ScopedDependency> scopedDependencies;
    private List<FeatureDependency> featureDependencies;
    protected Provider provider = null;
    
    public AbstractFactoryDependency(String artifactID, String extension) {
        super(artifactID, extension);
    }
    
    public AbstractFactoryDependency(String organizationID, String artifactID, String extension) {
        super(organizationID, artifactID, extension);
    }
    
    public AbstractFactoryDependency(String artifactID, String extension, Provider provider) {
        super(artifactID, extension);
        if (provider != null) {
            if (provider instanceof AbstractFactoryProvider) {
                ((AbstractFactoryProvider)provider).setImpl(this.organizationID + "/" + artifactID);
            }
            this.provider = provider;
        }        
    }
    
    public AbstractFactoryDependency(String organizationID, String artifactID, String extension, Provider provider) {
        super(organizationID, artifactID, extension);
        if (provider != null) {
            if (provider instanceof AbstractFactoryProvider) {
                ((AbstractFactoryProvider)provider).setImpl(this.organizationID + "/" + artifactID);
            }
            this.provider = provider;
        }        
    }
    
    public AbstractFactoryDependency(String organizationID, String artifactID, String version, String extension, Provider provider) {
        super(organizationID, artifactID, version, extension);
        if (provider != null) {
            if (provider instanceof AbstractFactoryProvider) {
                ((AbstractFactoryProvider)provider).setImpl(this.organizationID + "/" + artifactID);
            }
            this.provider = provider;
        }        
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.FactoryDependency#getProvidedDependencies()
     */
    @SuppressWarnings("unchecked")
    public List<ProvidedDependency> getProvidedDependencies() {
        if (providedDependencies == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(providedDependencies);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.FactoryDependency#getSharedDependencies()
     */
    @SuppressWarnings("unchecked")
    public List<SharedDependency> getSharedDependencies() {
        if (sharedDependencies == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(sharedDependencies);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.FactoryDependency#getScopedDependencies()
     */
    @SuppressWarnings("unchecked")
    public List<ScopedDependency> getScopedDependencies() {
        if (scopedDependencies == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(scopedDependencies);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.FactoryDependency#getFeatureDependencies()
     */
    @SuppressWarnings("unchecked")
    public List<FeatureDependency> getFeatureDependencies() {
        if (featureDependencies == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(featureDependencies);
    }
    
   /** ********************** unpublished ************************************** */
    
    public Provider getProvider() {
        return provider;
    }

    public void setFeatureDependencies(List<FeatureDependency> featureDependencies) {
        this.featureDependencies = featureDependencies;
    }

    public void setScopedDependencies(List<ScopedDependency> scopedDependencies) {
        this.scopedDependencies = scopedDependencies;
    }

    public void setSharedDependencies(List<SharedDependency> sharedDependencies) {
        this.sharedDependencies = sharedDependencies;
    }

    public void setProvidedDependencies(List<ProvidedDependency> providedDependencies) {
        this.providedDependencies = providedDependencies;
    }
    
}
