/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.dependency;

import org.bluestemsoftware.specification.eoa.FactoryDependency;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory.Provider;

public class FactoryDependencyImpl extends AbstractFactoryDependency implements FactoryDependency {
    
    public static String EXTENSION = "eoa-factory";
    
    public FactoryDependencyImpl(String organizationID, String artifactID) {
        super(organizationID, artifactID, EXTENSION);
    }
    
    public FactoryDependencyImpl(String artifactID, Provider provider) {
        super(artifactID, EXTENSION, provider);
    }
    
    public FactoryDependencyImpl(String organizationID, String artifactID, Provider provider) {
        super(organizationID, artifactID, EXTENSION, provider);
    }
    
    protected FactoryDependencyImpl(String organizationID, String artifactID, String extension, Provider provider) {
        super(organizationID, artifactID, extension, provider);
    }
            
}
