/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.dependency;

import org.bluestemsoftware.specification.eoa.FeatureDependency;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory.Provider;

public class FeatureDependencyImpl extends FactoryDependencyImpl implements FeatureDependency {

    public static final String EXTENSION = "eoa-feature";

    private boolean isRequired;

    public FeatureDependencyImpl(String organizationID, String artifactID, boolean isRequired, Provider provider) {
        super(organizationID, artifactID, EXTENSION, provider);
        this.isRequired = isRequired;
    }
    
    public FeatureDependencyImpl(String artifactID, boolean isRequired, Provider provider) {
        super(null, artifactID, EXTENSION, provider);
        this.isRequired = isRequired;
    }

    public boolean isRequired() {
        return isRequired;
    }

    public String getExtensionImplementationRef() {
        return organizationID + "/ + artifactID";
    }

}
