/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.feature;

import java.lang.reflect.Method;

import org.bluestemsoftware.open.eoa.test.system.util.MockExtensionProviderFactory;
import org.bluestemsoftware.specification.eoa.ext.ExtensionException;
import org.bluestemsoftware.specification.eoa.ext.feature.FeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.FeatureFactory;
import org.bluestemsoftware.specification.eoa.ext.feature.http.client.HTTPClientFeature;
import org.bluestemsoftware.specification.eoa.ext.feature.http.client.HTTPClientFeatureFactory;

public class HTTPClientFeatureFactoryProvider extends AbstractFeatureFactoryProvider implements HTTPClientFeatureFactory.Provider {

    public static final String NAME = "http-client-test";

    public HTTPClientFeatureFactoryProvider(MockExtensionProviderFactory mockExtensionProviderFactory) {
        super(mockExtensionProviderFactory);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getExtensionType()
     */
    public String spi_getExtensionType() {
        return HTTPClientFeature.TYPE;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.om.axiom.HTTPClientFeatureFactory$Provider#spi_createFeature()
     */
    public HTTPClientFeature.Provider spi_createFeature() throws FeatureException {
        Class<?>[] signature = new Class[] {};
        Method method = null;
        try {
            method = FeatureFactory.Provider.class.getMethod("spi_createFeature", signature);
        } catch (Exception fatchance) {
        }
        Object[] args = new Object[] {};
        try {
            return (HTTPClientFeature.Provider)mockExtensionProviderFactory.createExtensionProvider(method, args);
        } catch (ExtensionException ex) {
            throw new FeatureException(ex);
        }
    }
}
