/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.wsdl;

import java.lang.reflect.Method;

import javax.xml.transform.Source;

import org.bluestemsoftware.open.eoa.test.system.util.MockExtensionProviderFactory;
import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.component.ComponentContext;
import org.bluestemsoftware.specification.eoa.ext.ExtensionException;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.WSDLDocument;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.WSDLException;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Document;
import org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Factory;

public class WSDL11FactoryProvider implements WSDL11Factory.Provider {

    public static final String NAME = "wsdl-11-test";

    protected ExtensionFactory consumer;
    protected MockExtensionProviderFactory mockExtensionProviderFactory;
    
    public WSDL11FactoryProvider(MockExtensionProviderFactory mockExtensionProviderFactory) {
        this.mockExtensionProviderFactory = mockExtensionProviderFactory;
    }
    
    public MockExtensionProviderFactory getMockExtensionProviderFactory() {
        return mockExtensionProviderFactory;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.ExtensionFactory)
     */
    public void spi_setConsumer(ExtensionFactory consumer) {
        this.consumer = (WSDL11Factory)consumer;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getExtensionType()
     */
    public String spi_getExtensionType() {
        return WSDL11Document.TYPE;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.WSDLFactory$Provider#spi_readComponents(org.bluestemsoftware.specification.eoa.component.ComponentContext, org.bluestemsoftware.specification.eoa.ext.idl.wsdl.WSDLDocument)
     */
    public void spi_readComponents(ComponentContext componentContext, WSDLDocument wsdlDocument) throws DeploymentException {
        throw new UnsupportedOperationException("not mockable");
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Factory$Provider#spi_createDocument()
     */
    public WSDL11Document spi_createDocument() throws WSDLException {
        Class<?>[] signature = new Class[] {};
        Method method = null;
        try {
            method = WSDL11Factory.Provider.class.getMethod("spi_createDocument", signature);
        } catch (Exception fatchance) {
        }
        Object[] args = new Object[] {};
        try {
            return (WSDL11Document)mockExtensionProviderFactory.createExtensionProvider(method, args);
        } catch (ExtensionException ex) {
            throw new WSDLException(ex);
        }
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.idl.wsdl.wsdl11.WSDL11Factory$Provider#spi_createDocument(org.bluestemsoftware.specification.eoa.component.ComponentContext, javax.xml.transform.Source)
     */
    public WSDL11Document spi_createDocument(ComponentContext componentContext, Source source) throws WSDLException {
        Class<?>[] signature = new Class[] {ComponentContext.class, Source.class};
        Method method = null;
        try {
            method = WSDL11Factory.Provider.class.getMethod("spi_createDocument", signature);
        } catch (Exception fatchance) {
        }
        Object[] args = new Object[] {componentContext, source};
        try {
            return (WSDL11Document)mockExtensionProviderFactory.createExtensionProvider(method, args);
        } catch (ExtensionException ex) {
            throw new WSDLException(ex);
        }
    }

}
