/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.test.system;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.bluestemsoftware.open.eoa.test.system.AbstractIntegrationTest;
import org.bluestemsoftware.open.eoa.test.system.util.MockExtensionProviderFactory;
import org.bluestemsoftware.specification.eoa.ApplicationClassLoader;
import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.component.binding.Binding;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointActionReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointOperationReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EngineRT;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EngineReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.ServiceReference;
import org.bluestemsoftware.specification.eoa.component.intrface.InterfaceAction;
import org.bluestemsoftware.specification.eoa.component.intrface.InterfaceOperation;
import org.bluestemsoftware.specification.eoa.component.intrface.rt.ActionContext;
import org.bluestemsoftware.specification.eoa.component.intrface.rt.FaultContext;
import org.bluestemsoftware.specification.eoa.component.intrface.rt.MessageContext;
import org.bluestemsoftware.specification.eoa.component.intrface.rt.SystemFault;
import org.bluestemsoftware.specification.eoa.component.service.Endpoint;
import org.bluestemsoftware.specification.eoa.ext.ExecutableException;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.ExtensionException;
import org.bluestemsoftware.specification.eoa.ext.binding.BindingException;
import org.bluestemsoftware.specification.eoa.ext.binding.http.rt.HTTPBindingRT;
import org.bluestemsoftware.specification.eoa.ext.binding.soap.rt.SOAP11HTTPBindingRT;
import org.bluestemsoftware.specification.eoa.ext.binding.soap.rt.SOAP11VMBindingRT;
import org.bluestemsoftware.specification.eoa.ext.binding.soap.rt.SOAP12HTTPBindingRT;
import org.bluestemsoftware.specification.eoa.ext.binding.soap.rt.SOAP12VMBindingRT;
import org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerRequest;
import org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerResponse;
import org.w3c.dom.Element;

public abstract class AbstractApplicationTest
extends AbstractIntegrationTest {
    protected EngineRT engineUnderTest;
    protected EngineReference engineReference;

    protected void setUp() throws Exception {
        super.setUp();
        if (this.system.getEngine(this.getEngineName()) == null) {
            throw new IllegalStateException("Engine under test " + this.getEngineName() + " is undefined.");
        }
        this.engineUnderTest = this.system.getEngine(this.getEngineName()).getRuntimeProvider();
        this.engineReference = this.engineUnderTest.getEngineReference((QName)this.engineUnderTest.getName());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected RoleUnderTest getRoleUnderTest(String roleName) {
        ServiceReference sr = this.engineReference.getServiceReference(roleName);
        if (sr == null) {
            throw new IllegalStateException("Role " + roleName + " is undefined.");
        }
        return new RoleUnderTest(sr);
    }

    protected abstract QName getEngineName();

    private static class Callback {
        private String requestMessageID;
        private transient ActionContext response;

        public Callback(String requestMessageID) {
            this.requestMessageID = requestMessageID;
        }

        public ActionContext getResponse() {
            return this.response;
        }

        public String getRequestMessageID() {
            return this.requestMessageID;
        }

        public void setResponse(ActionContext response) {
            this.response = response;
        }
    }

    private static class MockHTTPBindingProvider
    extends AbstractBindingProvider
    implements HTTPBindingRT.Provider {
        private MockHTTPBindingProvider() {
        }

        public void spi_receiveAction(HTTPServerRequest request, HTTPServerResponse response, InterfaceAction.Direction direction, EndpointReference endpointReference) {
        }

        public void spi_sendAction(EndpointReference endpointReference, ActionContext actionContext) throws SystemFault {
            if (endpointReference.getParent().isMyService()) {
                this.sendMyServiceResponse(endpointReference, actionContext);
            } else {
                this.sendPartnerServiceRequest(endpointReference, actionContext);
            }
        }
    }

    private static class MockSOAPVMBindingProvider
    extends AbstractBindingProvider
    implements SOAP11VMBindingRT.Provider,
    SOAP12VMBindingRT.Provider {
        private MockSOAPVMBindingProvider() {
        }

        public void spi_receiveAction(EndpointReference endpointReference, InterfaceAction.Direction direction, Element envelope) {
        }

        public void spi_sendAction(EndpointReference endpointReference, ActionContext actionContext) throws SystemFault {
            if (endpointReference.getParent().isMyService()) {
                this.sendMyServiceResponse(endpointReference, actionContext);
            } else {
                this.sendPartnerServiceRequest(endpointReference, actionContext);
            }
        }
    }

    private static class MockSOAPHTTPBindingProvider
    extends AbstractBindingProvider
    implements SOAP11HTTPBindingRT.Provider,
    SOAP12HTTPBindingRT.Provider {
        private MockSOAPHTTPBindingProvider() {
        }

        public void spi_receiveAction(HTTPServerRequest request, HTTPServerResponse response, InterfaceAction.Direction direction, EndpointReference endpointReference) {
        }

        public void spi_sendAction(EndpointReference endpointReference, ActionContext actionContext) throws SystemFault {
            if (endpointReference.getParent().isMyService()) {
                this.sendMyServiceResponse(endpointReference, actionContext);
            } else {
                this.sendPartnerServiceRequest(endpointReference, actionContext);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AbstractBindingProvider {
        private Map<String, Callback> callbacks = new HashMap<String, Callback>();
        private Map<String, MockPartnerRole> mockPartnerRoles;

        private AbstractBindingProvider() {
        }

        public synchronized void registerCallback(Callback callback) {
            this.callbacks.put(callback.getRequestMessageID(), callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendMyServiceResponse(EndpointReference epr, ActionContext response) {
            String action = response.getAction();
            EndpointActionReference ear = epr.getEndpointActionReference(action);
            InterfaceAction.Direction dir = ear.getReferencedComponent().getInterfaceAction().getDirection();
            if (dir != InterfaceAction.Direction.OUT) {
                throw new IllegalStateException("An attempt was made to send 'my' service response for operation " + ear.getParent().getEndpointOperationName() + ", but action " + action + " has message direction 'In'. Did you intend to invoke 'receiveAction'");
            }
            Callback callback = null;
            Object object = this.callbacks;
            synchronized (object) {
                callback = this.callbacks.remove(response.getRelatesTo());
            }
            object = callback;
            synchronized (object) {
                callback.setResponse(response);
                callback.notify();
            }
        }

        protected void sendPartnerServiceRequest(EndpointReference epr, ActionContext request) {
            String action = request.getAction();
            EndpointActionReference ear = epr.getEndpointActionReference(action);
            InterfaceAction.Direction dir = ear.getReferencedComponent().getInterfaceAction().getDirection();
            if (dir != InterfaceAction.Direction.IN) {
                throw new IllegalStateException("An attempt was made to send 'partner' service request defined on operation " + ear.getParent().getEndpointOperationName() + ", but action " + action + " has message direction 'Out'. Did you intend to invoke 'sendAction'?");
            }
            String roleName = epr.getParent().getRoleName();
            MockPartnerRole mockPartnerRole = this.getMockPartnerRoles().get(roleName);
            if (mockPartnerRole == null) {
                throw new IllegalStateException("No MockPartnerRole defined for role '" + roleName + "'.");
            }
            ActionContext response = null;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                EngineRT engine = epr.getRootComponent();
                ApplicationClassLoader acl = engine.getApplicationClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)acl);
                MockPartnerOperation mockedOperation = new MockPartnerOperation(ear.getParent());
                response = mockPartnerRole.handleRequest(mockedOperation, request);
            }
            catch (Throwable th) {
                throw new RuntimeException("MockPartnerRole " + roleName + " threw unchecked exception. " + th);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            if (response != null) {
                epr.receiveAction(response);
            } else {
                InterfaceOperation.MEP mep = ear.getParent().getEndpointOperation().getInterfaceOperation().getMessageExchangePattern();
                if (mep == InterfaceOperation.MEP.IN_OUT) {
                    throw new RuntimeException("MockPartnerRole returned null response, operation " + ear.getParent().getEndpointOperationName() + " defines 'in-out' MEP.");
                }
            }
        }

        public void spi_destroy() {
        }

        public Set<String> spi_getRequiredBindingFeatures() {
            return new HashSet<String>();
        }

        public void spi_init() throws BindingException {
        }

        public boolean spi_isSuspended() {
            return true;
        }

        public void spi_resume() throws ExecutableException {
        }

        public void spi_suspend() throws ExecutableException {
        }

        public void spi_validateEndpointReference(EndpointReference endpointReference) throws DeploymentException {
        }

        public void spi_setConsumer(Extension consumer) {
        }

        private Map<String, MockPartnerRole> getMockPartnerRoles() {
            Map testProperties;
            if (this.mockPartnerRoles == null && (testProperties = (Map)System.getProperties().get("eoa.system.test.properties")) != null) {
                this.mockPartnerRoles = (Map)testProperties.get("mock.partner.roles");
                if (this.mockPartnerRoles == null) {
                    this.mockPartnerRoles = new HashMap<String, MockPartnerRole>();
                }
            }
            return this.mockPartnerRoles;
        }
    }

    public static class MockBindingFactory
    implements MockExtensionProviderFactory {
        public Extension.Provider createExtensionProvider(Method method, Object[] args) throws ExtensionException {
            String protocolType = (String)args[2];
            if (protocolType.equals("http://www.w3.org/2006/01/soap11/bindings/HTTP")) {
                return new MockSOAPHTTPBindingProvider();
            }
            if (protocolType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                return new MockSOAPHTTPBindingProvider();
            }
            if (protocolType.equals("http://bluestemsoftware.org/specification/eoa/ext/soap11/vmtp")) {
                return new MockSOAPVMBindingProvider();
            }
            if (protocolType.equals("http://bluestemsoftware.org/specification/eoa/ext/soap12/vmtp")) {
                return new MockSOAPVMBindingProvider();
            }
            if (protocolType.equals("http://www.w3.org/ns/wsdl/http")) {
                return new MockHTTPBindingProvider();
            }
            throw new IllegalArgumentException("Unsupported protocol " + protocolType);
        }
    }

    public class OperationUnderTest {
        private EndpointOperationReference eor;

        public OperationUnderTest(EndpointOperationReference eor) {
            this.eor = eor;
        }

        public ActionContext createRequest() {
            return this.eor.getRequestAction().createAction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActionContext sendRequest(ActionContext request) {
            Endpoint endpoint = this.eor.getParent().getEndpoint();
            Binding binding = endpoint.getBindingReference().getReferencedComponent();
            Extension.Provider p = binding.getRuntimeProvider().getExtensionProvider();
            if (!(p instanceof AbstractBindingProvider)) {
                throw new IllegalStateException("Binding provider not instance of " + AbstractBindingProvider.class);
            }
            Callback callback = new Callback(request.getMessageID());
            ((AbstractBindingProvider)p).registerCallback(callback);
            this.eor.getParent().receiveAction(request);
            Callback callback2 = callback;
            synchronized (callback2) {
                while (callback.getResponse() == null) {
                    try {
                        callback.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new IllegalStateException(ie);
                    }
                }
            }
            return callback.getResponse();
        }
    }

    public class RoleUnderTest {
        private ServiceReference sr;

        public RoleUnderTest(ServiceReference sr) {
            this.sr = sr;
        }

        public OperationUnderTest getOperationUnderTest(QName operationName) {
            EndpointReference epr = (EndpointReference)this.sr.getEndpointReferences().next();
            EndpointOperationReference eor = epr.getOperationReference(operationName);
            return new OperationUnderTest(eor);
        }
    }

    public static class MockPartnerOperation {
        private EndpointOperationReference eor;

        public MockPartnerOperation(EndpointOperationReference eor) {
            this.eor = eor;
        }

        public MessageContext createResponseAction(String relatesTo) {
            EndpointActionReference.ResponseActionReference ear = this.eor.getResponseAction();
            if (ear == null) {
                throw new IllegalArgumentException("Response action for operation " + this.eor.getEndpointOperationName() + " is undefined.");
            }
            return (MessageContext)ear.createAction(relatesTo);
        }

        public FaultContext createFaultAction(String relatesTo, QName faultName) {
            EndpointActionReference.ResponseActionReference ear = this.eor.getFaultAction(faultName);
            if (ear == null) {
                throw new IllegalArgumentException("Fault ref " + faultName + " is undefined on operation " + this.eor.getEndpointOperationName() + ".");
            }
            return (FaultContext)ear.createAction(relatesTo);
        }

        public FaultContext createSystemFaultAction(String relatesTo, String faultReason) {
            return this.eor.getParent().createSystemFaultAction(relatesTo, faultReason);
        }

        public FaultContext createSystemFaultAction(String relatesTo, QName faultCode, String faultReason) {
            return this.eor.getParent().createSystemFaultAction(relatesTo, faultCode, faultReason);
        }

        public FaultContext createSystemFaultAction(String relatesTo, String faultReason, Throwable cause) {
            return this.eor.getParent().createSystemFaultAction(relatesTo, faultReason, cause);
        }

        public FaultContext createSystemFaultAction(String relatesTo, Throwable cause) {
            return this.eor.getParent().createSystemFaultAction(relatesTo, cause);
        }

        public FaultContext createSystemFaultAction(String relatesTo, SystemFault systemFault) {
            return this.eor.getParent().createSystemFaultAction(relatesTo, systemFault);
        }
    }

    public static interface MockPartnerRole {
        public ActionContext handleRequest(MockPartnerOperation var1, ActionContext var2);
    }
}

