/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.feature;

import org.bluestemsoftware.open.eoa.test.system.dependency.AbstractFactoryProvider;
import org.bluestemsoftware.open.eoa.test.system.util.MockExtensionProviderFactory;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory;


public abstract class AbstractFeatureFactoryProvider implements AbstractFactoryProvider {
    
    protected String impl;
    protected ExtensionFactory consumer;
    protected MockExtensionProviderFactory mockExtensionProviderFactory;
    
    public AbstractFeatureFactoryProvider(MockExtensionProviderFactory mockExtensionProviderFactory) {
        this.mockExtensionProviderFactory = mockExtensionProviderFactory;
    }
    
    public void setImpl(String impl) {
        this.impl = impl;
    }
    
    public String spi_getFeatureImpl() {
        return impl;
    }
    
    public void spi_setConsumer(ExtensionFactory consumer) {
        this.consumer = consumer;
    }
    
    public MockExtensionProviderFactory getMockExtensionProviderFactory() {
        return mockExtensionProviderFactory;
    }


}
