/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.feature;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

import org.bluestemsoftware.open.eoa.test.system.dependency.AbstractDependency;
import org.bluestemsoftware.open.eoa.test.system.util.MockExtensionProviderFactory;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointActionReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.FeatureModule;
import org.bluestemsoftware.specification.eoa.component.engine.rt.TransportModule;
import org.bluestemsoftware.specification.eoa.component.policy.rt.ActionPolicy;
import org.bluestemsoftware.specification.eoa.component.policy.rt.UnsupportedPolicyException;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.ExtensionException;
import org.bluestemsoftware.specification.eoa.ext.feature.FeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.http.HTTPTransportFeature;
import org.bluestemsoftware.specification.eoa.system.ManagementContext;
import org.w3c.dom.Element;

/**
 * Creates a transport feature which provides no behavior.
 */
public class MockHTTPTransportFeatureFactory implements MockExtensionProviderFactory {

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.open.eoa.test.system.util.MockExtensionProviderFactory#createExtensionProvider(java.lang.reflect.Method,
     *      java.lang.Object[])
     */
    public Extension.Provider createExtensionProvider(Method method, Object[] args) throws ExtensionException {
        return new MockHTTPTransportFeature();
    }

    private class MockHTTPTransportFeature implements HTTPTransportFeature.Provider {

        public TransportModule spi_createDefaultTransportModule(EndpointReference epr) throws FeatureException {
            return null;
        }

        public TransportModule spi_createTransportModule(EndpointActionReference endpointActionReference, ActionPolicy privatePolicy, ActionPolicy publicPolicy) throws FeatureException, UnsupportedPolicyException {
            return null;
        }

        public Set<String> spi_getPolicyVocabularyNamespaces() {
            Set<String> pvns = new HashSet<String>();
            pvns.add("http://foo");
            return pvns;
        }

        public void spi_destroy() {
        }

        public String spi_getFeatureImpl() {
            return AbstractDependency.DEFAULT_ORGANIZATION_ID + "/" + HTTPTransportFeatureFactoryProvider.NAME;
        }

        public void spi_init(Set<ManagementContext> managementContexts) throws FeatureException {
        }

        public void spi_destroyFeatureModule(FeatureModule featureModule) {
        }

        public void spi_setConfiguration(Element configuration) {
        }

        public void spi_setConsumer(Extension consumer) {
        }

    }

}
