/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.types;

import java.lang.reflect.Method;
import java.util.Set;

import javax.xml.transform.Source;

import org.bluestemsoftware.open.eoa.test.system.dependency.FactoryDependencyImpl;
import org.bluestemsoftware.open.eoa.test.system.util.MockExtensionProviderFactory;
import org.bluestemsoftware.specification.eoa.component.types.rt.SchemaDocument;
import org.bluestemsoftware.specification.eoa.ext.ExtensionException;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.XMLSchemaException;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XMLSchema;
import org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XMLSchemaFactory;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/**
 * Wraps a user provided instance of {@link MockExtensionProviderFactory} which
 * facilitates the creation of mock/stubbed instances of {@link XMLSchema.Provider}
 * used within the context of a test.  See documentation for usage examples.
 * 
 * @see FactoryDependencyImpl
 */

public class XMLSchemaFactoryProvider implements XMLSchemaFactory.Provider {

    public static final String NAME = "xml-schema-test";
    
    protected ExtensionFactory consumer;
    protected MockExtensionProviderFactory mockExtensionProviderFactory;
    
    public XMLSchemaFactoryProvider(MockExtensionProviderFactory mockExtensionProviderFactory) {
        super();
        this.mockExtensionProviderFactory = mockExtensionProviderFactory;
    }
    
    public MockExtensionProviderFactory getMockExtensionProviderFactory() {
        return mockExtensionProviderFactory;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.ExtensionFactory)
     */
    public void spi_setConsumer(ExtensionFactory consumer) {
        this.consumer = (XMLSchemaFactory)consumer;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getExtensionType()
     */
    public String spi_getExtensionType() {
        return XMLSchema.TYPE;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.schema.SchemaFactory$Provider#spi_getTargetNamespace(org.w3c.dom.Element)
     */
    public String spi_getTargetNamespace(Element schemaElement) {
        if (schemaElement == null) {
            throw new IllegalArgumentException("schemaElement null");
        }
        return schemaElement.getAttribute("targetNamespace");
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XMLSchemaFactory$Provider#spi_dereferenceLocation(org.xml.sax.EntityResolver, java.lang.String)
     */
    public InputSource spi_dereferenceLocation(EntityResolver entityResolver, String location) throws XMLSchemaException {
        throw new UnsupportedOperationException("not mockable");
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.schema.xs.xs10.XMLSchemaFactory$Provider#spi_readSchemas(org.xml.sax.EntityResolver, javax.xml.transform.Source)
     */
    @SuppressWarnings("unchecked")
    public Set<SchemaDocument> spi_readSchemas(EntityResolver entityResolver, Source source) throws XMLSchemaException {
        Class<?>[] signature = new Class[] {EntityResolver.class, Source.class};
        Method method = null;
        try {
            method = XMLSchemaFactory.Provider.class.getMethod("spi_readSchemas", signature);
        } catch (Exception fatchance) {
        }
        Object[] args = new Object[] {entityResolver, source};
        try {
            return (Set<SchemaDocument>)mockExtensionProviderFactory.createExtensionProvider(method, args);
        } catch (ExtensionException ex) {
            throw new XMLSchemaException(ex);
        }
    }

}
