/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.util;

import java.io.File;

import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryDependencies;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryDeployment;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory.Provider;

/**
 * A lightweight deployment which may be used when creating dependent factories that create
 * mock extensions, i.e. in situations where real extensions are not required.
 */
public class FactoryDependencyDeployment extends ExtensionFactoryDeployment {

    private Provider provider;

    public FactoryDependencyDeployment(String organizationID, String artifactID, String version, String extension,
            File file, ExtensionFactoryDependencies deploymentDependencies, Provider provider) {
        super(organizationID, artifactID, version, extension, file, deploymentDependencies);
        this.provider = provider;
    }

    @Override
    public void deploy(ExtensionFactoryContext factoryContext) throws DeploymentException {
        setExtensionFactory(provider.getClass());
        super.deploy(factoryContext, provider);
    }

}
