/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.util;

import java.lang.reflect.Method;

import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.ExtensionException;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory;

/**
 * A factory for mock/stubbed <code>Extension</code> provider objects which will be delegated
 * to by instances of {@link ExtensionFactory.Provider}, i.e. instances defined within this
 * project which are <code>MockExtensionProviderFactory</code> aware, when asked by system to create an
 * <code>Extension</code> provider object within context of a test.
 */
public interface MockExtensionProviderFactory {

    /**
     * Creates mock <code>Extension</code> provider.
     * @param method
     *        method on factory for which call is delegated
     * @param args
     *        arguments passed to method on delegating factory
     * @return mock <code>Extension</code> object of appropriate type
     * @throws ExtensionException
     */
    public Extension.Provider createExtensionProvider(Method method, Object[] args) throws ExtensionException;
    
}
