/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

/**
 * Strips ALL white space and ignorable characters from a character stream, i.e. to facillitate
 * comparison of actual and expected results while disregarding differences which may be caused
 * by formatting.
 */
public class WhiteSpaceStripper extends FilterWriter {

    public WhiteSpaceStripper(Writer out) {
        super(out);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = off; i < len; i++) {
            write(cbuf[i]);
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (Character.isWhitespace(c) || Character.isIdentifierIgnorable(c)) {
            return;
        } else {
            super.write(c);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        write(str.toCharArray(), off, len);
    }

}