/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.test.system.dependency;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.bluestemsoftware.specification.eoa.Dependency;
import org.bluestemsoftware.specification.eoa.OtherDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDependency {
    public static final String DEFAULT_ORGANIZATION_ID = "org.mycompany.test";
    public static final String DEFAULT_VERSION = "1.0";
    protected File file = new File("");
    protected String organizationID = "org.mycompany.test";
    protected String artifactID;
    protected String version = "1.0";
    protected String extension;

    public AbstractDependency(String artifactID, String extension) {
        if (artifactID == null) {
            throw new IllegalArgumentException("artifactID null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("extension null");
        }
        this.artifactID = artifactID;
        this.extension = extension;
    }

    public AbstractDependency(File file, String artifactID, String extension) {
        if (file == null) {
            throw new IllegalArgumentException("file null");
        }
        if (artifactID == null) {
            throw new IllegalArgumentException("artifactID null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("extension null");
        }
        this.file = file;
        this.artifactID = artifactID;
        this.extension = extension;
    }

    public AbstractDependency(String organizationID, String artifactID, String extension) {
        if (artifactID == null) {
            throw new IllegalArgumentException("artifactID null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("extension null");
        }
        if (organizationID != null) {
            this.organizationID = organizationID;
        }
        this.artifactID = artifactID;
        this.extension = extension;
    }

    public AbstractDependency(String organizationID, String artifactID, String version, String extension) {
        if (artifactID == null) {
            throw new IllegalArgumentException("artifactID null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("extension null");
        }
        if (organizationID != null) {
            this.organizationID = organizationID;
        }
        this.artifactID = artifactID;
        this.extension = extension;
        if (version != null) {
            this.version = version;
        }
    }

    public AbstractDependency(File file, String organizationID, String artifactID, String version, String extension) {
        if (file == null) {
            throw new IllegalArgumentException("file null");
        }
        if (artifactID == null) {
            throw new IllegalArgumentException("artifactID null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("extension null");
        }
        this.file = file;
        if (organizationID != null) {
            this.organizationID = organizationID;
        }
        this.artifactID = artifactID;
        this.extension = extension;
        if (version != null) {
            this.version = version;
        }
    }

    public final String getRef() {
        return this.organizationID + "/" + this.artifactID + "/" + this.version + "/" + this.extension;
    }

    public final String getVersionlessRef() {
        return this.organizationID + "/" + this.artifactID + "/" + this.extension;
    }

    public final String getShortName() {
        if (this.artifactID == null) {
            throw new IllegalStateException("Error generating short name. 'artifactID' not defined");
        }
        if (this.version == null) {
            throw new IllegalStateException("Error generating short name. 'version' not defined");
        }
        if (this.extension == null) {
            throw new IllegalStateException("Error generating short name. 'extension' not defined");
        }
        return this.artifactID + ":" + this.version + ":" + this.extension;
    }

    public final String getOrganizationID() {
        return this.organizationID;
    }

    public final String getArtifactID() {
        return this.artifactID;
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getExtension() {
        return this.extension;
    }

    public Map<String, OtherDependency> getOtherDependencies() {
        return Collections.EMPTY_MAP;
    }

    public final File getFile() {
        return this.file;
    }

    public final String toString() {
        return this.getRef();
    }

    public final int hashCode() {
        return this.hashCode(this.getRef());
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Dependency)) {
            return false;
        }
        return this.getRef() == ((Dependency)obj).getRef() || this.getRef() != null && this.getRef().equals(((Dependency)obj).getRef());
    }

    private int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }
}

