/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.test.system.util;

import org.bluestemsoftware.open.eoa.test.system.util.Worker;
import org.bluestemsoftware.open.eoa.test.system.util.WorkerFactory;

public class MultiThreadedTest {
    private int runningThreads;
    private Thread[] testThreads = null;
    private Thread waitingThread = null;
    private boolean success = true;
    private Object lock = new Object();

    public MultiThreadedTest(int threads, WorkerFactory workerFactory) {
        this.runningThreads = threads;
        this.testThreads = new Thread[threads];
        for (int i = 0; i < threads; ++i) {
            this.testThreads[i] = new TestThread(workerFactory.createWorker());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (MultiThreadedTest.this.waitingThread != null) {
                    MultiThreadedTest.this.waitingThread.interrupt();
                }
            }
        });
        for (int i = 0; i < this.testThreads.length; ++i) {
            this.testThreads[i].start();
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.runningThreads > 0) {
                try {
                    this.waitingThread = Thread.currentThread();
                    this.lock.wait();
                    this.waitingThread = null;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.success;
    }

    private class TestThread
    extends Thread {
        private Worker worker;

        public TestThread(Worker worker) {
            this.worker = worker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.worker.doWork();
            }
            catch (Throwable th) {
                System.err.println("worker threw exception: " + th);
                MultiThreadedTest.this.success = false;
            }
            finally {
                try {
                    Object object = MultiThreadedTest.this.lock;
                    synchronized (object) {
                        --MultiThreadedTest.this.runningThreads;
                        MultiThreadedTest.this.lock.notifyAll();
                    }
                }
                catch (Exception ignore) {}
            }
        }
    }
}

