/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.cfg;

import java.util.Map;

import org.bluestemsoftware.open.eoa.test.system.AbstractApplicationTest.MockPartnerRole;

/**
 * Manages a common <code>System</code> configuration shared by a suite of application tests, i.e.
 * tests which extend {@link AbstractApplicationTest} and which are defined within a suite's
 * 'system' sub-directory. Invoked by SurefireMojo once per test suite within context of a
 * forked jvm.
 */
public interface ApplicationConfiguration extends SystemConfiguration {

    public Map<String, MockPartnerRole> getMockPartnerRoles();

}
