/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.system.engine;

import org.bluestemsoftware.open.eoa.test.system.dependency.FactoryDependencyImpl;
import org.bluestemsoftware.open.eoa.test.system.util.MockExtensionProviderFactory;
import org.bluestemsoftware.specification.eoa.ext.engine.default10.DefaultEngine;
import org.bluestemsoftware.specification.eoa.ext.engine.default10.DefaultEngineFactory;

/**
 * Wraps a user provided instance of {@link MockExtensionProviderFactory} which
 * facilitates the creation of mock/stubbed instances of {@link DefaultEngine.Provider}
 * used within the context of a test.  See documentation for usage examples.
 * 
 * @see FactoryDependencyImpl
 */

public class DefaultEngineFactoryProvider implements DefaultEngineFactory.Provider {

    public static final String NAME = "default-engine-test";

    private MockExtensionProviderFactory mockExtensionProviderFactory;

    public DefaultEngineFactoryProvider(MockExtensionProviderFactory mockExtensionProviderFactory) {
        this.mockExtensionProviderFactory = mockExtensionProviderFactory;
    }

    public MockExtensionProviderFactory getMockExtensionProviderFactory() {
        return mockExtensionProviderFactory;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getExtensionType()
     */
    public String spi_getExtensionType() {
        return DefaultEngine.TYPE;
    }

}
