/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.test.system;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.log4j.xml.DOMConfigurator;
import org.bluestemsoftware.open.eoa.test.system.dependency.FactoryDependencyImpl;
import org.bluestemsoftware.open.eoa.test.system.dependency.FeatureDependencyImpl;
import org.bluestemsoftware.open.eoa.test.system.util.FactoryDependencyDeployment;
import org.bluestemsoftware.open.eoa.test.system.util.FactoryUnderTestDeployment;
import org.bluestemsoftware.specification.eoa.AbstractClassLoader;
import org.bluestemsoftware.specification.eoa.DeploymentClassLoader;
import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.FactoryDependency;
import org.bluestemsoftware.specification.eoa.FeatureDependency;
import org.bluestemsoftware.specification.eoa.SystemDependencies;
import org.bluestemsoftware.specification.eoa.component.ClasspathDeployment;
import org.bluestemsoftware.specification.eoa.component.ComponentContext;
import org.bluestemsoftware.specification.eoa.component.ComponentDeployment;
import org.bluestemsoftware.specification.eoa.component.ComponentManager;
import org.bluestemsoftware.specification.eoa.component.FragmentIdentifier;
import org.bluestemsoftware.specification.eoa.component.RootComponent;
import org.bluestemsoftware.specification.eoa.component.application.Application;
import org.bluestemsoftware.specification.eoa.component.binding.Binding;
import org.bluestemsoftware.specification.eoa.component.engine.Engine;
import org.bluestemsoftware.specification.eoa.component.intrface.Interface;
import org.bluestemsoftware.specification.eoa.component.message.InterfaceMessage;
import org.bluestemsoftware.specification.eoa.component.policy.Policy;
import org.bluestemsoftware.specification.eoa.component.rt.ProviderReader;
import org.bluestemsoftware.specification.eoa.component.service.Service;
import org.bluestemsoftware.specification.eoa.component.types.Schema;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.ExtensionException;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryDependencies;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryDeployment;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryManager;
import org.bluestemsoftware.specification.eoa.ext.application.ApplicationFactory;
import org.bluestemsoftware.specification.eoa.ext.binding.BindingFactory;
import org.bluestemsoftware.specification.eoa.ext.connector.ConnectorFactory;
import org.bluestemsoftware.specification.eoa.ext.container.ContainerException;
import org.bluestemsoftware.specification.eoa.ext.container.ContainerFactory;
import org.bluestemsoftware.specification.eoa.ext.engine.EngineFactory;
import org.bluestemsoftware.specification.eoa.ext.expression.ExpressionFactory;
import org.bluestemsoftware.specification.eoa.ext.feature.FeatureFactory;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.rt.TransportProtocolRT;
import org.bluestemsoftware.specification.eoa.ext.idl.IDLFactory;
import org.bluestemsoftware.specification.eoa.ext.management.ManagementContextFactory;
import org.bluestemsoftware.specification.eoa.ext.message.MessageFactory;
import org.bluestemsoftware.specification.eoa.ext.policy.PolicyFactory;
import org.bluestemsoftware.specification.eoa.ext.schema.SchemaFactory;
import org.bluestemsoftware.specification.eoa.ext.server.ServerException;
import org.bluestemsoftware.specification.eoa.ext.server.ServerFactory;
import org.bluestemsoftware.specification.eoa.system.ManagementContext;
import org.bluestemsoftware.specification.eoa.system.System;
import org.bluestemsoftware.specification.eoa.system.SystemClassLoader;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.bluestemsoftware.specification.eoa.system.container.Connector;
import org.bluestemsoftware.specification.eoa.system.container.Container;
import org.bluestemsoftware.specification.eoa.system.server.Feature;
import org.bluestemsoftware.specification.eoa.system.server.Server;
import org.bluestemsoftware.specification.eoa.system.server.TransportFeature;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractUnitTest
implements org.bluestemsoftware.specification.eoa.system.System {
    public static final String SYS_ORGANIZATION_ID = "com.mycompany.eoa";
    public static final String SYS_ARTIFACT_ID = "mysystem";
    public static final String SYS_VERSION = "1.0";
    protected File baseDir;
    protected File classesDir;
    protected File resourcesDir;
    protected SystemContext systemContext = new SystemContextImpl();
    protected ComponentManager componentManager;
    protected static ExtensionFactoryManager factoryManager;
    protected File systemVarDir;
    protected File systemTmpDir;
    protected File systemEtcDir;
    protected URI systemNamespace;
    protected String myOrganizationID;
    protected String myArtifactID;
    protected String myExtension;
    protected String myVersion;
    protected boolean factoryUnderTest;
    protected boolean initializeContainer = true;
    protected boolean initializeServer = true;
    private String versionlessRef;

    protected void setUp() throws Exception {
        this.myOrganizationID = System.getProperty("eoa.system.dut.groupid");
        this.myArtifactID = System.getProperty("eoa.system.dut.artifactid");
        this.myExtension = System.getProperty("eoa.system.dut.packaging");
        this.baseDir = new File(System.getProperty("basedir"));
        this.versionlessRef = this.myOrganizationID + "/" + this.myArtifactID + "/" + this.myExtension;
        this.classesDir = new File(this.baseDir, "target/classes");
        this.resourcesDir = System.getProperty("testClassesDirectory") != null ? new File(System.getProperty("testClassesDirectory")) : new File(this.baseDir, "target/test-classes");
        factoryManager = new ExtensionFactoryManager(null);
        this.componentManager = new ComponentManager(this.getLog(this.getClass()), null, new HashSet());
        Properties properties = System.getProperties();
        DeploymentClassLoader dcl = (DeploymentClassLoader)properties.get("eoa.system.deployment.classloader");
        ComponentContext ctx = new ComponentContext((ComponentDeployment)new ClasspathDeployment.BuiltInComponentsDeployment((AbstractClassLoader)dcl), dcl);
        this.componentManager.insert(ctx);
        DOMConfigurator.configure((URL)Thread.currentThread().getContextClassLoader().getResource("log4j.xml"));
        SystemDependencies sd = this.getSystemDependencies();
        for (FactoryDependency efd : sd.getFactoryDependencies()) {
            this.deployExtensionFactory(efd);
        }
        if (!this.factoryUnderTest) {
            throw new Exception("System dependencies must define 'factory under test' as a dependency");
        }
        if (this.initializeServer) {
            this.getServer().init(new HashSet());
        }
        if (this.initializeContainer) {
            this.getContainer().init(new HashSet());
        }
    }

    protected void tearDown() throws Exception {
        this.getContainer().destroy();
        this.getServer().destroy();
    }

    public SystemDependencies getSystemDependencies() {
        ArrayList shds = new ArrayList();
        ArrayList<FactoryDependencyImpl> efds = new ArrayList<FactoryDependencyImpl>();
        ArrayList cds = new ArrayList();
        FactoryDependencyImpl efd = null;
        if (this.myExtension.equals(FactoryDependencyImpl.EXTENSION)) {
            efd = new FactoryDependencyImpl(this.myOrganizationID, this.myArtifactID);
        } else if (this.myExtension.equals("eoa-feature")) {
            efd = new FeatureDependencyImpl(this.myOrganizationID, this.myArtifactID, true, null);
        } else {
            throw new IllegalStateException("Unit test not supported for project type " + this.myExtension);
        }
        efds.add(efd);
        return new SystemDependencies(SYS_ORGANIZATION_ID, SYS_ARTIFACT_ID, SYS_VERSION, shds, efds, cds);
    }

    public RootComponent getComponent(FragmentIdentifier fragmentID) {
        if (fragmentID == null) {
            return null;
        }
        return this.componentManager.getComponent(fragmentID);
    }

    public ComponentDeployment getComponentDeployment(String deploymentRef) {
        return this.componentManager.getComponentDeployment(deploymentRef);
    }

    public Application getApplication(QName componentName) {
        return (Application)this.componentManager.getComponent(RootComponent.ComponentType.APPLICATION, componentName);
    }

    public Binding getBinding(QName componentName) {
        return (Binding)this.componentManager.getComponent(RootComponent.ComponentType.BINDING, componentName);
    }

    public Engine getEngine(QName componentName) {
        return (Engine)this.componentManager.getComponent(RootComponent.ComponentType.ENGINE, componentName);
    }

    public Interface getInterface(QName componentName) {
        return (Interface)this.componentManager.getComponent(RootComponent.ComponentType.INTERFACE, componentName);
    }

    public InterfaceMessage getMessage(QName componentName) {
        return (InterfaceMessage)this.componentManager.getComponent(RootComponent.ComponentType.MESSAGE, componentName);
    }

    public Policy getPolicy(QName componentName) {
        return (Policy)this.componentManager.getComponent(RootComponent.ComponentType.POLICY, componentName);
    }

    public Schema getSchema(QName componentName) {
        return (Schema)this.componentManager.getComponent(RootComponent.ComponentType.SCHEMA, componentName);
    }

    public Service getService(QName componentName) {
        return (Service)this.componentManager.getComponent(RootComponent.ComponentType.SERVICE, componentName);
    }

    public ProviderReader<?> getProviderReader(String providerNamespace) {
        return factoryManager.getProviderReader(providerNamespace);
    }

    public ExtensionFactory getExtensionFactory(String deploymentRef) {
        return factoryManager.getExtensionFactory(deploymentRef);
    }

    public List<ExtensionFactory> getExtensionFactories() {
        return factoryManager.getExtensionFactories();
    }

    public final ApplicationFactory getApplicationFactory(String ref) {
        return factoryManager.getApplicationFactory(ref);
    }

    public final ExpressionFactory getExpressionFactory(String ref) {
        return factoryManager.getExpressionFactory(ref);
    }

    public ContainerFactory getContainerFactory(String ref) {
        if (ref.equals("http://test/container")) {
            return ContainerFactoryImpl.getInstance();
        }
        return factoryManager.getContainerFactory(ref);
    }

    public ServerFactory getServerFactory(String ref) {
        if (ref.equals("http://test/server")) {
            return ServerFactoryImpl.getInstance();
        }
        return factoryManager.getServerFactory(ref);
    }

    public final EngineFactory getEngineFactory(String ref) {
        return factoryManager.getEngineFactory(ref);
    }

    public final BindingFactory getBindingFactory(String ref) {
        return factoryManager.getBindingFactory(ref);
    }

    public Set<BindingFactory> getBindingFactories() {
        return factoryManager.getBindingFactories();
    }

    public final SchemaFactory getSchemaFactory(String ref) {
        return factoryManager.getSchemaFactory(ref);
    }

    public final ConnectorFactory getConnectorFactory(String ref, String impl) {
        return factoryManager.getConnectorFactory(ref, impl);
    }

    public final IDLFactory getIDLFactory(String ref) {
        return factoryManager.getIDLFactory(ref);
    }

    public Set<PolicyFactory> getPolicyFactories() {
        return factoryManager.getPolicyFactories();
    }

    public Set<SchemaFactory> getSchemaFactories() {
        return factoryManager.getSchemaFactories();
    }

    public final PolicyFactory getPolicyFactory(String ref) {
        return factoryManager.getPolicyFactory(ref);
    }

    public MessageFactory getMessageFactory(String ref) {
        return factoryManager.getMessageFactory(ref);
    }

    public FeatureFactory getFeatureFactory(String featureType, String impl) {
        return factoryManager.getFeatureFactory(featureType, impl);
    }

    public Container getContainer() {
        return ContainerImpl.getInstance();
    }

    public Server getServer() {
        return ServerImpl.getInstance();
    }

    public System.Log getLog(Class<?> clazz) {
        return new NoOpLog();
    }

    public String getRef() {
        return "http://test/system";
    }

    public File getSystemVarDir() {
        if (this.systemVarDir == null) {
            this.systemVarDir = new File(this.baseDir, "target/var");
            if (!this.systemVarDir.exists()) {
                this.systemVarDir.mkdir();
                this.systemVarDir.deleteOnExit();
            }
        }
        return this.systemVarDir;
    }

    public File getSystemTmpDir() {
        if (this.systemTmpDir == null) {
            this.systemTmpDir = new File(this.baseDir, "target/tmp");
            if (!this.systemTmpDir.exists()) {
                this.systemTmpDir.mkdir();
                this.systemTmpDir.deleteOnExit();
            }
        }
        return this.systemTmpDir;
    }

    public File getSystemEtcDir() {
        if (this.systemEtcDir == null) {
            this.systemEtcDir = new File(this.baseDir, "target/etc");
            if (!this.systemEtcDir.exists()) {
                this.systemEtcDir.mkdir();
                this.systemEtcDir.deleteOnExit();
            }
        }
        return this.systemEtcDir;
    }

    private void deployExtensionFactory(FactoryDependency efd) throws DeploymentException {
        for (FeatureDependency ffd : efd.getFeatureDependencies()) {
            this.deployExtensionFactory((FactoryDependency)ffd);
        }
        if (efd.getVersionlessRef().equals(this.versionlessRef)) {
            this.deployFactoryUnderTest(efd);
        } else {
            this.deployFactoryDependency(efd);
        }
    }

    private void deployFactoryUnderTest(FactoryDependency efd) throws DeploymentException {
        Properties properties = System.getProperties();
        DeploymentClassLoader dcl = (DeploymentClassLoader)properties.get("eoa.system.deployment.classloader");
        File file = this.classesDir;
        String organizationID = efd.getOrganizationID();
        String artifactID = efd.getArtifactID();
        String version = efd.getVersion();
        String extension = efd.getExtension();
        List prds = efd.getProvidedDependencies();
        List shds = efd.getSharedDependencies();
        List scds = efd.getScopedDependencies();
        List ffds = efd.getFeatureDependencies();
        Map ods = efd.getOtherDependencies();
        ExtensionFactoryDependencies dd = new ExtensionFactoryDependencies(prds, shds, scds, ffds, ods);
        FactoryUnderTestDeployment dep = new FactoryUnderTestDeployment(organizationID, artifactID, version, extension, file, dd);
        ExtensionFactoryContext factoryContext = new ExtensionFactoryContext((ExtensionFactoryDeployment)dep, dcl);
        factoryManager.deploy(factoryContext);
        this.factoryUnderTest = true;
    }

    private void deployFactoryDependency(FactoryDependency efd) throws DeploymentException {
        Properties properties = System.getProperties();
        DeploymentClassLoader dcl = (DeploymentClassLoader)properties.get("eoa.system.deployment.classloader");
        File file = efd.getFile();
        String organizationID = efd.getOrganizationID();
        String artifactID = efd.getArtifactID();
        String version = efd.getVersion();
        String extension = efd.getExtension();
        List prds = efd.getProvidedDependencies();
        List shds = efd.getSharedDependencies();
        List scds = efd.getScopedDependencies();
        List ffds = efd.getFeatureDependencies();
        Map ods = efd.getOtherDependencies();
        ExtensionFactoryDependencies dd = new ExtensionFactoryDependencies(prds, shds, scds, ffds, ods);
        ExtensionFactory.Provider p = ((FactoryDependencyImpl)efd).getProvider();
        FactoryDependencyDeployment deployment = new FactoryDependencyDeployment(organizationID, artifactID, version, extension, file, dd, p);
        ExtensionFactoryContext factoryContext = new ExtensionFactoryContext((ExtensionFactoryDeployment)deployment, dcl);
        factoryManager.deploy(factoryContext);
    }

    public MessageFactory getDefaultMessageFactory() {
        return null;
    }

    public Set<ManagementContextFactory> getManagementContextFactories() {
        return new HashSet<ManagementContextFactory>();
    }

    public Set<ManagementContext> getManagementContexts() {
        return new HashSet<ManagementContext>();
    }

    private static class ContainerFactoryImpl
    extends ContainerFactory {
        private static ContainerFactory singleton = new ContainerFactoryImpl();

        private ContainerFactoryImpl() {
        }

        public static ContainerFactory getInstance() {
            return singleton;
        }

        public String getExtensionType() {
            return "http://test/container";
        }

        public Container createContainer(DOMSource domSource) throws ContainerException {
            return ContainerImpl.getInstance();
        }
    }

    private static class ServerFactoryImpl
    extends ServerFactory {
        private static ServerFactory singleton = new ServerFactoryImpl();

        private ServerFactoryImpl() {
        }

        public static ServerFactory getInstance() {
            return singleton;
        }

        public Server createServer(DOMSource domSource) throws ServerException {
            return ServerImpl.getInstance();
        }

        public String getExtensionType() {
            return "http://test/server";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ContainerImpl
    extends Container {
        public static final String TYPE = "http://test/container";
        private Map<String, Connector> connectors = new HashMap<String, Connector>();
        private Map<String, Connector> defaultConnectors = new HashMap<String, Connector>();
        private static ContainerImpl singleton;

        public static Container getInstance() {
            if (singleton == null) {
                singleton = new ContainerImpl((ExtensionFactory)ContainerFactoryImpl.getInstance(), new ContainerProviderImpl(), null, null);
            }
            return singleton;
        }

        private ContainerImpl(ExtensionFactory factory, Container.Provider provider, File extensionEtcDir, File extensionVarDir) {
            super(factory, provider, extensionEtcDir, extensionVarDir);
        }

        public Connector getConnector(String name) {
            return this.connectors.get(name);
        }

        public Set<Connector> getConnectors() {
            return new HashSet<Connector>(this.connectors.values());
        }

        public Connector getDefaultConnector(String typeRef) {
            return this.defaultConnectors.get(typeRef);
        }

        public Container.Provider getProvider() {
            return null;
        }

        public void addConnector(Connector connector) {
            this.connectors.put(connector.getConnectorName(), connector);
            this.defaultConnectors.put(connector.getExtensionType(), connector);
        }

        public void destroy() {
            this.connectors.clear();
            this.defaultConnectors.clear();
        }

        public void init(Set<ManagementContext> managementContexts) throws ExtensionException {
        }

        public Connector getSystemDataSource() {
            return null;
        }

        private static class ContainerProviderImpl
        implements Container.Provider {
            private ContainerProviderImpl() {
            }

            public void spi_setConsumer(Extension consumer) {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ServerImpl
    extends Server {
        public static final String TYPE = "http://test/server";
        private static Server singleton;
        private Map<Class<?>, Feature> features = new HashMap();
        private Map<String, Feature> featuresByTypeRef = new HashMap<String, Feature>();

        public ServerImpl(ExtensionFactory factory, Server.Provider provider, File extensionEtcDir, File extensionVarDir) {
            super(factory, provider, extensionEtcDir, extensionVarDir);
        }

        public static Server getInstance() {
            if (singleton == null) {
                singleton = new ServerImpl((ExtensionFactory)ServerFactoryImpl.getInstance(), new ServerProviderImpl(), null, null);
            }
            return singleton;
        }

        public void init(Set<ManagementContext> managementContexts) throws ExtensionException {
            for (ExtensionFactory ef : factoryManager.getExtensionFactories()) {
                if (!(ef instanceof FeatureFactory)) continue;
                Feature temp = ((FeatureFactory)ef).createFeature();
                if (this.features.containsKey(temp.getClass())) {
                    throw new ExtensionException("AbstractUnitTest supports only one impl per feature type");
                }
                temp.init(managementContexts);
                this.features.put(temp.getClass(), temp);
                this.featuresByTypeRef.put(temp.getExtensionType(), temp);
            }
        }

        public void destroy() {
            this.features.clear();
        }

        public Server.Provider getProvider() {
            return null;
        }

        public List<Feature> getFeatures() {
            return new ArrayList<Feature>();
        }

        public void updateFeatureConfiguration(Feature feature, Element configuration) {
        }

        public Feature getFeature(String featureType) {
            return this.featuresByTypeRef.get(featureType);
        }

        public TransportFeature getTransportFeature(Class<? extends TransportProtocolRT> arg0) {
            return null;
        }

        public <T extends Feature> T getFeature(Class<T> featureType) {
            return (T)((Feature)featureType.cast(this.features.get(featureType)));
        }

        private static class ServerProviderImpl
        implements Server.Provider {
            private ServerProviderImpl() {
            }

            public void spi_setConsumer(Extension consumer) {
            }
        }
    }

    class SystemContextImpl
    extends SystemContext {
        private SystemClassLoader systemClassLoader;

        SystemContextImpl() {
            systemContext = this;
        }

        public org.bluestemsoftware.specification.eoa.system.System getSystem() {
            return AbstractUnitTest.this;
        }

        public SystemClassLoader getSystemClassLoader() {
            if (this.systemClassLoader == null) {
                this.systemClassLoader = new SystemClassLoader(new URL[0]);
            }
            return this.systemClassLoader;
        }
    }

    static class NoOpLog
    implements System.Log {
        NoOpLog() {
        }

        public void debug(String message, Throwable t) {
        }

        public void debug(String message) {
        }

        public void error(String message, Throwable cause) {
        }

        public void error(String message) {
        }

        public void fatal(String message, Throwable t) {
        }

        public void fatal(String message) {
        }

        public void info(String message, Throwable cause) {
        }

        public void info(String message) {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public void trace(String message, Throwable cause) {
        }

        public void trace(String message) {
        }

        public void warn(String message, Throwable cause) {
        }

        public void warn(String message) {
        }
    }
}

