/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.test.system.cfg;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.xml.DOMConfigurator;
import org.bluestemsoftware.open.eoa.test.system.cfg.SystemConfiguration;
import org.bluestemsoftware.open.eoa.test.system.dependency.FactoryDependencyImpl;
import org.bluestemsoftware.open.eoa.test.system.util.FactoryDependencyDeployment;
import org.bluestemsoftware.open.eoa.test.system.util.SetupException;
import org.bluestemsoftware.specification.eoa.ComponentDependency;
import org.bluestemsoftware.specification.eoa.Deployment;
import org.bluestemsoftware.specification.eoa.DeploymentClassLoader;
import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.FactoryDependency;
import org.bluestemsoftware.specification.eoa.SharedClassLoader;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryDependencies;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryDeployment;
import org.bluestemsoftware.specification.eoa.system.System;
import org.bluestemsoftware.specification.eoa.system.SystemClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractSystemConfiguration
implements SystemConfiguration {
    protected System system;
    protected String myOrganizationID;
    protected String myArtifactID;
    protected String myExtension;
    protected String myVersion;
    protected File baseDir;
    protected File resourcesDir;
    protected File classesDir;
    protected File containerFile;
    protected File serverFile;
    protected File etcDir;
    protected Class<?> systemImplClass;
    protected transient int exitCode;
    protected Deployment deploymentUnderTest;

    @Override
    public boolean setUp() throws Exception {
        this.myOrganizationID = java.lang.System.getProperty("eoa.system.dut.groupid");
        this.myArtifactID = java.lang.System.getProperty("eoa.system.dut.artifactid");
        this.myExtension = java.lang.System.getProperty("eoa.system.dut.packaging");
        this.myVersion = java.lang.System.getProperty("eoa.system.dut.version");
        this.baseDir = new File(java.lang.System.getProperty("basedir"));
        this.classesDir = new File(this.baseDir, "target/classes");
        this.resourcesDir = new File(java.lang.System.getProperty("testClassesDirectory"));
        if (!this.testsExist(this.resourcesDir)) {
            return true;
        }
        Map<String, Object> testProperties = this.setSystemProperties();
        this.defineFactoryUnderTest(testProperties);
        this.addMockFactoryDependencies(testProperties);
        testProperties.put("mockComponentDependencies", this.getMockComponentDependencies());
        return this.bootstrapSystem();
    }

    @Override
    public boolean destroy() {
        if (!this.testsExist(this.resourcesDir)) {
            return true;
        }
        if (this.system == null) {
            return false;
        }
        Boolean success = false;
        try {
            Method mainMethod = this.systemImplClass.getDeclaredMethod("shutdown", new Class[0]);
            success = (Boolean)mainMethod.invoke((Object)this.system, new Object[0]);
        }
        catch (Exception ex) {
            java.lang.System.err.println(ex.toString());
        }
        return success;
    }

    protected Set<FactoryDependency> getMockFactoryDependencies() {
        return Collections.EMPTY_SET;
    }

    protected Set<ComponentDependency> getMockComponentDependencies() {
        return Collections.EMPTY_SET;
    }

    private Map<String, Object> setSystemProperties() throws Exception {
        File systemDir = new File(this.resourcesDir, "alakai");
        java.lang.System.setProperty("eoa.system.dir", systemDir.getAbsolutePath());
        this.etcDir = new File(systemDir, "etc/");
        java.lang.System.setProperty("eoa.system.etc.dir", this.etcDir.getAbsolutePath());
        String containerConfigDir = "org.bluestemsoftware.open.eoa.ext.standalone-10-container";
        String serverConfigDir = "org.bluestemsoftware.open.eoa.ext.standalone-10-server";
        this.containerFile = new File(this.etcDir, containerConfigDir + File.separator + "config.xml");
        this.serverFile = new File(this.etcDir, serverConfigDir + File.separator + "config.xml");
        String prop = java.lang.System.getenv().get("ALAKAI_HOME");
        if (prop == null) {
            throw new SetupException("Environment variable ALAKAI_HOME not set.");
        }
        File homeDir = new File(new File(prop).getCanonicalPath());
        File libDir = new File(homeDir, "lib");
        java.lang.System.setProperty("eoa.system.lib.dir", libDir.getAbsolutePath());
        File varDir = new File(this.baseDir, "target/var");
        if (!varDir.exists()) {
            varDir.mkdir();
            varDir.deleteOnExit();
        }
        java.lang.System.setProperty("eoa.system.var.dir", varDir.getAbsolutePath());
        File tmpDir = new File(this.baseDir, "target/tmp");
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
            tmpDir.deleteOnExit();
        }
        java.lang.System.setProperty("eoa.system.tmp.dir", tmpDir.getAbsolutePath());
        java.lang.System.setProperty("eoa.system.namespace", "http://mycompany.com/eoa/component");
        HashMap<String, Object> testProperties = new HashMap<String, Object>();
        java.lang.System.getProperties().put("eoa.system.test.properties", testProperties);
        return testProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bootstrapSystem() throws Exception {
        Appender appender;
        String prop = java.lang.System.getProperty("eoa.system.lib.dir");
        File libDir = new File(new File(prop).getCanonicalPath());
        if (!libDir.exists()) {
            throw new SetupException("required property 'eoa.system.lib.dir' points to an invalid path '" + libDir.getAbsolutePath() + "'.");
        }
        File[] contents = libDir.listFiles(new JarFilter());
        if (contents.length == 0) {
            throw new SetupException("no system artifacts found within dir " + libDir.toString());
        }
        URL[] artifacts = new URL[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            artifacts[i] = contents[i].toURI().toURL();
        }
        ClassLoader pcl = (ClassLoader)java.lang.System.getProperties().get("eoa.system.parent.classloader");
        SharedClassLoader scl = (SharedClassLoader)java.lang.System.getProperties().get("eoa.system.shared.classloader");
        SystemClassLoader systemClassLoader = new SystemClassLoader(pcl, artifacts);
        systemClassLoader.setSharedClassLoader(scl);
        File loggingConfig = new File(this.etcDir, "log4j.xml");
        if (!loggingConfig.exists()) {
            throw new SetupException("missing logging configuration " + loggingConfig.getCanonicalPath());
        }
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)systemClassLoader);
            DOMConfigurator.configure((String)loggingConfig.getCanonicalPath());
            Enumeration e = Logger.getRootLogger().getAllAppenders();
            while (e.hasMoreElements()) {
                appender = (Appender)e.nextElement();
                if (!(appender instanceof WriterAppender)) continue;
                ((WriterAppender)appender).setEncoding("UTF-8");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
        java.lang.System.setProperty("org.apache.commons.logging.LogFactory", "org.apache.commons.logging.impl.LogFactoryImpl");
        try {
            this.systemImplClass = systemClassLoader.loadClass("org.bluestemsoftware.open.eoa.system.alakai.standalone.SystemImpl");
            Method getInstance = this.systemImplClass.getMethod("getInstance", new Class[0]);
            Object obj = getInstance.invoke(this.systemImplClass, new Object[0]);
            this.system = (System)System.class.cast(obj);
        }
        catch (Exception ex) {
            throw new SetupException(ex.toString());
        }
        Thread bootstrapper = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Class[] signature = new Class[]{File.class, File.class};
                    Method mainMethod = AbstractSystemConfiguration.this.systemImplClass.getDeclaredMethod("main", signature);
                    System system = AbstractSystemConfiguration.this.system;
                    synchronized (system) {
                        AbstractSystemConfiguration.this.exitCode = (Integer)mainMethod.invoke(AbstractSystemConfiguration.this.systemImplClass, AbstractSystemConfiguration.this.containerFile, AbstractSystemConfiguration.this.serverFile);
                        AbstractSystemConfiguration.this.system.notifyAll();
                    }
                }
                catch (Exception ex) {
                    java.lang.System.err.println(ex.toString());
                }
            }
        };
        bootstrapper.setContextClassLoader((ClassLoader)systemClassLoader);
        bootstrapper.start();
        Method isStarted = this.systemImplClass.getDeclaredMethod("isStarted", new Class[0]);
        appender = this.system;
        synchronized (appender) {
            while (this.exitCode > -1 && isStarted.invoke((Object)this.system, new Object[0]).equals(Boolean.FALSE)) {
                try {
                    this.system.wait();
                }
                catch (InterruptedException ignore) {}
            }
        }
        if (this.exitCode < 0) {
            return false;
        }
        Method resumeAll = this.systemImplClass.getDeclaredMethod("resumeAll", new Class[0]);
        resumeAll.invoke((Object)this.system, new Object[0]);
        if (this.myExtension.equals("eoa-component")) {
            String ref = this.myOrganizationID + "/" + this.myArtifactID + "/" + this.myVersion + "/" + this.myExtension;
            this.deploymentUnderTest = this.system.getComponentDeployment(ref);
            if (this.deploymentUnderTest == null) {
                throw new SetupException("Component deployment under test' " + ref + "' was never deployed.");
            }
        } else {
            String vref = this.myOrganizationID + "/" + this.myArtifactID + "/" + this.myExtension;
            if (this.system.getExtensionFactory(vref) == null) {
                throw new SetupException("Deployment for factory under test' " + vref + "' was never deployed.");
            }
            this.deploymentUnderTest = this.system.getExtensionFactory(vref).getFactoryContext().getDeployment();
        }
        return true;
    }

    private void defineFactoryUnderTest(Map<String, Object> testProperties) throws DeploymentException {
        Object dcl = java.lang.System.getProperties().get("eoa.system.deployment.classloader");
        Object scl = java.lang.System.getProperties().get("eoa.system.shared.classloader");
        testProperties.put("organizationID", this.myOrganizationID);
        testProperties.put("artifactID", this.myArtifactID);
        testProperties.put("version", this.myVersion);
        testProperties.put("extension", this.myExtension);
        testProperties.put("deploymentClassLoader", dcl);
        testProperties.put("sharedClassLoader", scl);
    }

    private void addMockFactoryDependencies(Map<String, Object> testProperties) {
        Set<FactoryDependency> mockFactoryDependencies = this.getMockFactoryDependencies();
        HashSet<ExtensionFactoryContext> mockFactoryDeployments = new HashSet<ExtensionFactoryContext>();
        for (FactoryDependency efd : mockFactoryDependencies) {
            Object dcl = java.lang.System.getProperties().get("eoa.system.deployment.classloader");
            File file = efd.getFile();
            String organizationID = efd.getOrganizationID();
            String artifactID = efd.getArtifactID();
            String version = efd.getVersion();
            String extension = efd.getExtension();
            List prds = efd.getProvidedDependencies();
            List shds = efd.getSharedDependencies();
            List scds = efd.getScopedDependencies();
            List ffds = efd.getFeatureDependencies();
            Map ods = efd.getOtherDependencies();
            ExtensionFactoryDependencies dd = new ExtensionFactoryDependencies(prds, shds, scds, ffds, ods);
            ExtensionFactory.Provider p = ((FactoryDependencyImpl)efd).getProvider();
            FactoryDependencyDeployment deployment = new FactoryDependencyDeployment(organizationID, artifactID, version, extension, file, dd, p);
            ExtensionFactoryContext efc = new ExtensionFactoryContext((ExtensionFactoryDeployment)deployment, (DeploymentClassLoader)dcl);
            mockFactoryDeployments.add(efc);
        }
        testProperties.put("mockFactoryDependencies", mockFactoryDependencies);
        testProperties.put("mockFactoryDeployments", mockFactoryDeployments);
    }

    private boolean testsExist(File directory) {
        boolean exists = false;
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                exists = this.testsExist(file);
                if (!exists) continue;
                break;
            }
            if (!file.getName().endsWith(".class")) continue;
            exists = true;
            break;
        }
        return exists;
    }

    static class JarFilter
    implements FileFilter {
        JarFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.toString().endsWith("jar");
        }
    }
}

