/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.test.system.dependency;

import java.util.Collections;
import java.util.List;
import org.bluestemsoftware.open.eoa.test.system.dependency.AbstractDependency;
import org.bluestemsoftware.open.eoa.test.system.dependency.AbstractFactoryProvider;
import org.bluestemsoftware.specification.eoa.FeatureDependency;
import org.bluestemsoftware.specification.eoa.ProvidedDependency;
import org.bluestemsoftware.specification.eoa.ScopedDependency;
import org.bluestemsoftware.specification.eoa.SharedDependency;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFactoryDependency
extends AbstractDependency {
    private List<ProvidedDependency> providedDependencies;
    private List<SharedDependency> sharedDependencies;
    private List<ScopedDependency> scopedDependencies;
    private List<FeatureDependency> featureDependencies;
    protected ExtensionFactory.Provider provider = null;

    public AbstractFactoryDependency(String artifactID, String extension) {
        super(artifactID, extension);
    }

    public AbstractFactoryDependency(String organizationID, String artifactID, String extension) {
        super(organizationID, artifactID, extension);
    }

    public AbstractFactoryDependency(String artifactID, String extension, ExtensionFactory.Provider provider) {
        super(artifactID, extension);
        if (provider != null) {
            if (provider instanceof AbstractFactoryProvider) {
                ((AbstractFactoryProvider)provider).setImpl(this.organizationID + "/" + artifactID);
            }
            this.provider = provider;
        }
    }

    public AbstractFactoryDependency(String organizationID, String artifactID, String extension, ExtensionFactory.Provider provider) {
        super(organizationID, artifactID, extension);
        if (provider != null) {
            if (provider instanceof AbstractFactoryProvider) {
                ((AbstractFactoryProvider)provider).setImpl(this.organizationID + "/" + artifactID);
            }
            this.provider = provider;
        }
    }

    public AbstractFactoryDependency(String organizationID, String artifactID, String version, String extension, ExtensionFactory.Provider provider) {
        super(organizationID, artifactID, version, extension);
        if (provider != null) {
            if (provider instanceof AbstractFactoryProvider) {
                ((AbstractFactoryProvider)provider).setImpl(this.organizationID + "/" + artifactID);
            }
            this.provider = provider;
        }
    }

    public List<ProvidedDependency> getProvidedDependencies() {
        if (this.providedDependencies == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.providedDependencies);
    }

    public List<SharedDependency> getSharedDependencies() {
        if (this.sharedDependencies == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.sharedDependencies);
    }

    public List<ScopedDependency> getScopedDependencies() {
        if (this.scopedDependencies == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.scopedDependencies);
    }

    public List<FeatureDependency> getFeatureDependencies() {
        if (this.featureDependencies == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.featureDependencies);
    }

    public ExtensionFactory.Provider getProvider() {
        return this.provider;
    }

    public void setFeatureDependencies(List<FeatureDependency> featureDependencies) {
        this.featureDependencies = featureDependencies;
    }

    public void setScopedDependencies(List<ScopedDependency> scopedDependencies) {
        this.scopedDependencies = scopedDependencies;
    }

    public void setSharedDependencies(List<SharedDependency> sharedDependencies) {
        this.sharedDependencies = sharedDependencies;
    }

    public void setProvidedDependencies(List<ProvidedDependency> providedDependencies) {
        this.providedDependencies = providedDependencies;
    }
}

