/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.binding.http.dfault;

import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.ext.binding.http.HTTPBindingFactory;
import org.bluestemsoftware.specification.eoa.ext.binding.http.rt.HTTPBindingConfiguration;
import org.bluestemsoftware.specification.eoa.ext.binding.http.rt.HTTPBindingRT;

public final class HTTPBindingFactoryImpl implements HTTPBindingFactory.Provider {

    public static final String NAME = "http-binding-default";

    public static final String IMPL = "http://bluestemsoftware.org/specification/eoa/ext/binding/http/default/1.0";

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.binding.BindingFactory$Provider#spi_getBindingImpl()
     */
    public String spi_getBindingImpl() {
        return IMPL;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.binding.soap.SOAPBindingFactory$Provider#spi_createDefaultProvider(org.bluestemsoftware.specification.eoa.ext.binding.soap.SOAPBindingFactory, org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName, java.lang.String)
     */
    public HTTPBindingRT.Provider spi_createDefaultProvider(HTTPBindingFactory factory, ComponentName componentName, String protocolType) throws DeploymentException {
        return new HTTPBindingImpl(new HTTPBindingConfiguration());
    }

   /*
    * (non-Javadoc)
    * @see org.bluestemsoftware.specification.eoa.ext.binding.http.HTTPBindingFactory$Provider#spi_createProvider(org.bluestemsoftware.specification.eoa.ext.binding.http.HTTPBindingFactory, org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName, java.lang.String, org.w3c.dom.Element)
    */
    public HTTPBindingRT.Provider spi_createProvider(HTTPBindingFactory factory, ComponentName componentName, String protocolType, HTTPBindingConfiguration hbc) throws DeploymentException {
        return new HTTPBindingImpl(hbc);
    }

}
