/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.binding.http.dfault.mgmt;

import javax.management.JMException;

import org.bluestemsoftware.open.eoa.ext.binding.http.dfault.HTTPBindingImpl;
import org.bluestemsoftware.open.eoa.ext.binding.http.dfault.mgmt.jmx.BindingMXBean;
import org.bluestemsoftware.specification.eoa.ext.ExecutableException;

/**
 * Encapsulates feature management which includes implementation of administrative operations
 * which MAY be invoked at runtime.
 */

public class Binding implements BindingMXBean {

    private HTTPBindingImpl up;

    public Binding(HTTPBindingImpl up) {
        this.up = up;
    }

    public void resume() throws JMException {
        try {
            up.spi_resume();
        } catch (ExecutableException se) {
            throw new JMException(se.getMessage());
        }
    }

    public void suspend() throws JMException {
        try {
            up.spi_suspend();
        } catch (ExecutableException se) {
            throw new JMException(se.getMessage());
        }
    }

    public Boolean isSuspended() {
        return up.spi_isSuspended();
    }

}
