/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.binding.http.dfault.util;



public class Constants {

    /** **************************** HTTP Constants ********************************* */

    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String COMPRESSION_GZIP = "gzip";
    public static final String MEDIA_TYPE_X_WWW_FORM = "application/x-www-form-urlencoded";
    public static final String MEDIA_TYPE_TEXT_XML = "text/xml";
    public static final String MEDIA_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MEDIA_TYPE_APPLICATION_XML = "application/xml";
    public static final String MEDIA_TYPE_APPLICATION_JSON = "application/json";
    public static final String MEDIA_TYPE_APPLICATION_JSON_BADGER = "application/json/badgerfish";
    public static final String MEDIA_TYPE_TEXT_JAVASCRIPT = "text/javascript";
    public static final String MEDIA_TYPE_TEXT_JSON = "text/json";
    public static final String MEDIA_TYPE_DEFAULT = "text/plain";
    public static final String DEFAULT_CONTENT_TYPE = "text/plain; charset=us-ascii";
    public static final String APPLICATION_XML_CONTENT_TYPE = Constants.MEDIA_TYPE_APPLICATION_XML + "; charset=utf-8";
    public static final String APPLICATION_JSON_CONTENT_TYPE = Constants.MEDIA_TYPE_APPLICATION_JSON + "; charset=utf-8";
    public static final String APPLICATION_JSON_BADGER_CONTENT_TYPE = Constants.MEDIA_TYPE_APPLICATION_JSON_BADGER + "; charset=utf-8";
    public static final String TEXT_JAVASCRIPT_CONTENT_TYPE = Constants.MEDIA_TYPE_TEXT_JAVASCRIPT + "; charset=utf-8";
    public static final String TEXT_JSON_CONTENT_TYPE = Constants.MEDIA_TYPE_TEXT_JSON + "; charset=utf-8";
    public static final String MULTIPART_FORM_DATA_CONTENT_TYPE = Constants.MEDIA_TYPE_MULTIPART_FORM_DATA + "; charset=utf-8";
    public static final String X_WWW_FORM_CONTENT_TYPE = Constants.MEDIA_TYPE_X_WWW_FORM + "; charset=utf-8";
    public static final String LEGAL_CHARACTERS_IN_URL = "-._~!$&()*+,;=:@?/%";
    public static final String LEGAL_CHARACTERS_IN_PATH = "-._~!$'()*+,;=:@";
    public static final String LEGAL_CHARACTERS_IN_QUERY = "-._~!$'()*+,;=:@/?";
    public static final String DIGITS = "0123456789ABCDEF";
    public static final int SC_CONTINUE = 100;
    public static final int SC_SWITCHING_PROTOCOLS = 101;
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_RESET_CONTENT = 205;
    public static final int SC_PARTIAL_CONTENT = 206;
    public static final int SC_MULTIPLE_CHOICES = 300;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_FOUND = 302;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_USE_PROXY = 305;
    public static final int SC_TEMPORARY_REDIRECT = 307;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_PAYMENT_REQUIRED = 402;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_NOT_ACCEPTABLE = 406;
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int SC_REQUEST_TIMEOUT = 408;
    public static final int SC_CONFLICT = 409;
    public static final int SC_GONE = 410;
    public static final int SC_LENGTH_REQUIRED = 411;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int SC_REQUEST_URI_TOO_LONG = 414;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int SC_EXPECTATION_FAILED = 417;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_GATEWAY_TIMEOUT = 504;
    public static final int SC_HTTP_VERSION_NOT_SUPPORTED = 505;

    
    /** **************************** JMS Constants ************************ */

    public static final String MESSAGE_ID_PROPERTY = "MessageID";
    public static final String MY_SERVICE_PROPERTY = "MyService";
    public static final String FILE_NAME_PROPERTY = "FileName";
    public static final String GZIP_RESPONSE_PROPERTY = "GZIPResponse";
    public static final String IS_FAULT_RESPONSE_PROPERTY = "IsFaultRespone";
    public static final String ACTION_PROPERTY = "Action";

    /** **************************** XS Constants ************************ */

    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_PREFIX = "XSI";
    
    
    /** **************************** Misc Constants ************************ */

    public static final String LINE_BREAK = System.getProperty("line.separator");
    public static final String UTF_8 = "utf-8";

}
