/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.binding.http.dfault.util;

import org.bluestemsoftware.specification.eoa.component.intrface.rt.ActionContext;
import org.bluestemsoftware.specification.eoa.ext.binding.http.rt.HTTPFault;
import org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerResponse;

/**
 * Wraps an http fault response. Used in instances where fault is generated before request
 * is passed to application layer, i.e. a binding generated response.
 */
public class HTTPFaultContext extends ActionContext {

    private HTTPServerResponse response;
    private MessageModules requestModules;
    private HTTPFault httpFault;

    private static final long serialVersionUID = 1L;

    public HTTPFaultContext(HTTPServerResponse response, MessageModules requestModules, MessageModules responseModules, HTTPFault httpFault) {
        this.response = response;
        this.requestModules = requestModules;
        this.messageModules = responseModules;
        this.httpFault = httpFault;
    }

    public HTTPFault getHTTPFault() {
        return httpFault;
    }
    
    public MessageModules getRequestModules() {
        return requestModules;
    }
    
    public HTTPServerResponse getResponse() {
        return response;
    }

}
