package org.bluestemsoftware.open.eoa.ext.binding.http.dfault.util;

import javax.xml.namespace.QName;

import org.bluestemsoftware.specification.eoa.component.intrface.rt.MessageModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/**
 * Identifies media type used to send response.
 */

public class MediaTypeModule extends MessageModule {

    public static final String TYPE = MediaTypeModule.class.getName();
    public static final String NAMESPACE_URI = "http://bluestemsoftware.org/open/eoa/ext/binding/http/default/mtm/1.0";

    private String mediaType;

    
    public MediaTypeModule(String mediaType) {
        this.mediaType = mediaType;
    }

    
    public String getMediaType() {
        return mediaType;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.component.intrface.rt.MessageModule#getNamespace()
     */
    @Override
    public String getNamespace() {
        return NAMESPACE_URI;
    }

    public static MediaTypeModule valueOf(Element element) {
        if (element == null || !element.getNamespaceURI().equals(TYPE)) {
            throw new IllegalArgumentException("Expected element of type " + new QName(TYPE, "mediaType"));
        }
        return new MediaTypeModule(getText(element));
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.component.intrface.rt.MessageModule#toElement(org.w3c.dom.Document)
     */
    @Override
    public Element toElement(Document ownerDocument) {
        Element wrapper = ownerDocument.createElementNS(TYPE, "mtm:mediaType");
        wrapper.setAttribute("namespace", NAMESPACE_URI);
        wrapper.appendChild(ownerDocument.createTextNode(mediaType));
        return wrapper;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.component.intrface.rt.MessageModule#getType()
     */
    @Override
    public String getType() {
        return TYPE;
    }

    private static String getText(Element element) {
        if (element == null || !element.hasChildNodes()) {
            return null;
        }
        try {
            Text textNode = (Text)element.getFirstChild();
            return textNode.getData();
        } catch (ClassCastException ce) {
        }
        return null;
    }

}
