/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package org.bluestemsoftware.open.eoa.ext.binding.http.dfault.util;

import org.bluestemsoftware.specification.eoa.ext.feature.http.client.HTTPClientRequest.Method;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.http.HTTPMethod;

public class MethodUtil {

    public static Method valueOf(HTTPMethod method) {
        if (method == HTTPMethod.POST) {
            return Method.POST;
        } else if (method == HTTPMethod.GET) {
            return Method.GET;
        } else if (method == HTTPMethod.PUT) {
            return Method.PUT;
        } else {
            return Method.DELETE;
        }
    }

}
