/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.binding.http.dfault.util;

import java.io.InputStream;
import java.util.Map;

import org.apache.axiom.om.OMElement;
import org.bluestemsoftware.specification.eoa.component.intrface.InterfaceOperation.Style;
import org.bluestemsoftware.specification.eoa.component.message.rt.Content;
import org.bluestemsoftware.specification.eoa.ext.binding.http.rt.HTTPSenderFault;
import org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerRequest;

/**
 * Utility class used to handle messages formatted using 'multipart/form-data' media type.
 */
public class MultipartFormDataUtil extends MediaTypeUtil {

    private static MultipartFormDataUtil singleton = new MultipartFormDataUtil();

    private MultipartFormDataUtil() {
    }

    static MultipartFormDataUtil getInstance() {
        return singleton;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.open.eoa.ext.binding.http.dfault.util.MediaTypeUtil#requiresRequestBody()
     */
    @Override
    public boolean requiresRequestBody() {
        return true;
    }

    @Override
    public OMElement readData(HTTPServerRequest request, Map<String, Style> styles, String location, String separator, String encoding, boolean isGZIP) throws Exception {
        return null; // TODO: implement. not much demand for this, i'm guessing
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.open.eoa.ext.binding.http.dfault.util.MediaTypeUtil#writeData(org.bluestemsoftware.specification.eoa.component.message.rt.Content, java.util.Map, java.lang.String, java.lang.String, java.lang.String, boolean)
     */
    @Override
    public InstanceData writeData(Content payload, Map<String, Style> styles, String address, String location, String separator, boolean ignoreUncited) throws Exception {
        // we do not format outgoing requests with this media type
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public OMElement readResponse(InputStream in, String encoding) throws Exception {
        throw new HTTPSenderFault("Unsupported response media type " + Constants.MEDIA_TYPE_MULTIPART_FORM_DATA);
    }
    
}
