/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.binding.http.dfault.util.dao;

import java.sql.SQLException;

import javax.sql.DataSource;

import org.bluestemsoftware.open.eoa.ext.binding.http.dfault.util.dao.derby.DerbyMessageDAO;
import org.bluestemsoftware.specification.eoa.ext.binding.http.HTTPBindingException;
import org.bluestemsoftware.specification.eoa.ext.connector.db.DataSourceConnector;
import org.bluestemsoftware.specification.eoa.ext.connector.db.DataSourceConnector.Dialect;

public abstract class MessageDAO {

    /**
     * Inserts message.
     * 
     * @param messageID
     * @param myService
     *        required in addition to messageid to make primary key unique, i.e. when partner
     *        engine is defined on same machine. true if receiving my service request or
     *        sending my service response. false if sending partner service request or
     *        receiving partner service response.
     * @throws SQLException
     */
    public abstract void insertMessage(String messageID, boolean myService) throws SQLException;

    public abstract MessageDAO init() throws HTTPBindingException;
    
    public abstract void destroy();
    
    public static MessageDAO getInstance(DataSource dataSource) throws HTTPBindingException {
        Dialect dialect = ((DataSourceConnector)dataSource).getDataSourceDialect();
        if (dialect == Dialect.DERBY) {
            return DerbyMessageDAO.getInstance(dataSource);
        } else {
            throw new HTTPBindingException("Dialect " + dialect + " not currently supported.");
        }
    }
	
}