/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.binding.http.dfault.util.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class JMSRequestor {

    private JMSRequestorFactory factory;
    private QueueSession session = null;
    private TemporaryQueue temporaryQueue;
    private final String SELECTOR_PREFIX = "JMSCorrelationID = '";
    private final String SELECTOR_SUFFIX = "'";

    public JMSRequestor(JMSRequestorFactory factory, QueueConnection rcvConnection) throws JMSException {
        this.factory = factory;
        session = rcvConnection.createQueueSession(false, javax.jms.Session.AUTO_ACKNOWLEDGE);
        temporaryQueue = session.createTemporaryQueue();
    }

    public Message receive(String jmsCorrelationID, long timeout) throws JMSException {
        String selector = SELECTOR_PREFIX + jmsCorrelationID + SELECTOR_SUFFIX;
        QueueReceiver queueReceiver = session.createReceiver(temporaryQueue, selector);
        Message response = queueReceiver.receive(timeout);
        return response;
    }

    public TemporaryQueue getTemporaryQueue() throws JMSException {
        return temporaryQueue;
    }

    public void destroy() throws JMSException {
        session.close();
        temporaryQueue.delete();
    }
    
    @Override
    protected void finalize() throws Throwable {
        factory.destroyObject(this);
    }

}
